from apm import *

## Linear model of a Boeing 747
#  Level flight at 40,000 ft elevation
#  Velocity at 774 ft/sec (0.80 Mach)

# States
#  u - uw (ft/sec) - horizontal velocity - horizontal wind
#  w - ww (ft/sec) - vertical velocity - vertical wind
#  q (crad/sec) - angular velocity
#  theta (crad) - angle from horizontal
# note: crad = 0.01 rad

# Inputs
#  e - elevator
#  t - throttle

# Outputs
#  u - uw (ft/sec) - horizontal airspeed
#  hdot = -w + u0 * theta with u0 = 774 ft/sec

## continuous time simulation
s = 'http://byu.apmonitor.com'
a = '747c'

# elevator step
apm(s,a,'clear all')
apm_load(s,a,'747c.apm')
csv_load(s,a,'step_elevator.csv')
apm_option(s,a,'nlc.imode',4)
apm_option(s,a,'nlc.nodes',3)
apm(s,a,'solve')
z1 = apm_sol(s,a)

# throttle step
apm(s,a,'clear all')
apm_load(s,a,'747c.apm')
csv_load(s,a,'step_throttle.csv')
apm_option(s,a,'nlc.imode',4)
apm_option(s,a,'nlc.nodes',3)
apm(s,a,'solve')
z2 = apm_sol(s,a)

## discrete time simulation
s = 'http://byu.apmonitor.com'
a = '747d'

# elevator step
apm(s,a,'clear all')
apm_load(s,a,'747d.apm')
csv_load(s,a,'step_elevator2.csv')
apm_option(s,a,'nlc.imode',4)
apm(s,a,'solve')
z3 = apm_sol(s,a)

# throttle step
apm(s,a,'clear all')
apm_load(s,a,'747d.apm')
csv_load(s,a,'step_throttle2.csv')
apm_option(s,a,'nlc.imode',4)
apm(s,a,'solve')
z4 = apm_sol(s,a)

import matplotlib.pyplot as plt
plt.figure(1)
plt.subplot(321)
plt.plot(z1['time'],z1['u[1]'],'r-')
plt.ylabel('MV_1') 
plt.legend(['Elevator'])

plt.subplot(322)
plt.plot(z2['time'],z2['u[2]'],'b-')
plt.ylabel('MV_2') 
plt.legend(['Throttle'])

plt.subplot(323)
plt.plot(z1['time'],z1['y[1]'],'r-')
plt.plot(z3['time'],z3['y[1]'],'k--')
plt.ylabel('CV_1') 
plt.legend(['Air Speed'])

plt.subplot(324)
plt.plot(z2['time'],z2['y[1]'],'b-')
plt.plot(z4['time'],z4['y[1]'],'g:')
plt.ylabel('CV_1') 
plt.legend(['Air Speed'])

plt.subplot(325)
plt.plot(z1['time'],z1['y[2]'],'r-')
plt.plot(z3['time'],z3['y[2]'],'k--')
plt.ylabel('CV_2') 
plt.legend(['Climb Rate'])

plt.subplot(326)
plt.plot(z2['time'],z2['y[2]'],'b-')
plt.plot(z4['time'],z4['y[2]'],'g:')
plt.ylabel('CV_2') 
plt.legend(['Climb Rate'])

plt.show()
