clear all; close all; clc

addpath('apm')

%% Linear model of a Boeing 747
%  Level flight at 40,000 ft elevation
%  Velocity at 774 ft/sec (0.80 Mach)

% States
%  u - uw (ft/sec) - horizontal velocity - horizontal wind
%  w - ww (ft/sec) - vertical velocity - vertical wind
%  q (crad/sec) - angular velocity
%  theta (crad) - angle from horizontal
% note: crad = 0.01 rad

% Inputs
%  e - elevator
%  t - throttle

% Outputs
%  u - uw (ft/sec) - horizontal airspeed
%  hdot = -w + u0 * theta with u0 = 774 ft/sec

%% continuous time simulation
s = 'http://byu.apmonitor.com';
a = '747c';

% elevator step
apm(s,a,'clear all');
apm_load(s,a,'747c.apm');
csv_load(s,a,'step_elevator.csv');
apm_option(s,a,'nlc.imode',4);
apm_option(s,a,'nlc.nodes',3);
apm(s,a,'solve')
s1 = apm_sol(s,a); z1 = s1.x;

% throttle step
apm(s,a,'clear all');
apm_load(s,a,'747c.apm');
csv_load(s,a,'step_throttle.csv');
apm_option(s,a,'nlc.imode',4);
apm_option(s,a,'nlc.nodes',3);
apm(s,a,'solve');
s2 = apm_sol(s,a); z2 = s2.x;


%% discrete time simulation
s = 'http://byu.apmonitor.com';
a = '747d';

% elevator step
apm(s,a,'clear all');
apm_load(s,a,'747d.apm');
csv_load(s,a,'step_elevator2.csv');
apm_option(s,a,'nlc.imode',4);
apm(s,a,'solve');
s3 = apm_sol(s,a); z3 = s3.x;

% throttle step
apm(s,a,'clear all');
apm_load(s,a,'747d.apm');
csv_load(s,a,'step_throttle2.csv');
apm_option(s,a,'nlc.imode',4);
apm(s,a,'solve');
s4 = apm_sol(s,a); z4 = s4.x;


figure(1)
subplot(3,2,1)
plot(z1.time,z1.u1,'r-','LineWidth',2)
ylabel('MV_1') 
legend('Elevator')

subplot(3,2,2)
plot(z2.time,z2.u2,'b-','LineWidth',2)
ylabel('MV_2') 
legend('Throttle')

subplot(3,2,3)
plot(z1.time,z1.y1,'r-','LineWidth',2)
hold on
plot(z3.time,z3.y1,'k--','LineWidth',2)
ylabel('CV_1') 
legend('Air Speed')

subplot(3,2,4)
plot(z2.time,z2.y1,'b-','LineWidth',2)
hold on
plot(z4.time,z4.y1,'g:','LineWidth',2)
ylabel('CV_1') 
legend('Air Speed')

subplot(3,2,5)
plot(z1.time,z1.y2,'r-','LineWidth',2)
hold on
plot(z3.time,z3.y2,'k--','LineWidth',2)
ylabel('CV_2') 
legend('Climb Rate')

subplot(3,2,6)
plot(z2.time,z2.y2,'b-','LineWidth',2)
hold on
plot(z4.time,z4.y2,'g:','LineWidth',2)
ylabel('CV_2') 
legend('Climb Rate')
