import numpy as np
from scipy import signal
import matplotlib.pyplot as plt


# generate LTI model
# Linear model of a Boeing 747
#  Level flight at 40,000 ft elevation
#  Velocity at 774 ft/sec (0.80 Mach)

# States
#  u - uw (ft/sec) - horizontal velocity - horizontal wind
#  w - ww (ft/sec) - vertical velocity - vertical wind
#  q (crad/sec) - angular velocity
#  theta (crad) - angle from horizontal
# note: crad = 0.01 rad
A = np.array([[-0.003, 0.039, 0.000, -0.322], \
              [-0.065,-0.319, 7.740,  0.000], \
              [ 0.020,-0.101,-0.429,  0.000], \
              [ 0.000, 0.000, 1.000,  0.000]])
# Inputs
#  e - elevator
#  t - throttle
B = np.array([[ 0.010, 1.000], \
              [-0.180,-0.040], \
              [-1.160, 0.598], \
              [ 0.000, 0.000]])
# Outputs
#  u - uw (ft/sec) - horizontal airspeed
#  hdot = -w + u0 * theta with u0 = 774 ft/sec
C = np.array([[1,  0, 0, 0], \
              [0, -1, 0, 7.74]])
D = np.array([[0, 0], \
              [0, 0]])

time = np.linspace(0,10,50)

# first step - elevator
B = np.array([[ 0.010], \
              [-0.180], \
              [-1.160], \
              [ 0.000]])
C = np.array([[1,  0, 0, 0]])
D = np.array([[0]])
sys = signal.StateSpace(A,B,C,D)
t1,y1=signal.step(sys,T=time)

# second step - throttle
B = np.array([[ 1.000], \
              [-0.040], \
              [ 0.598], \
              [ 0.000]])
C = np.array([[0,  -1, 0, 7.74]])
D = np.array([[0]])
sys = signal.StateSpace(A,B,C,D)
t2,y2=signal.step(sys,T=time)

plt.figure(1)
plt.subplot(2,1,1)
plt.plot(t1,y1,'b:',linewidth=2,label='Elevator step')
plt.legend(loc='best')
plt.subplot(2,1,2)
plt.plot(t2,y2,'r-',linewidth=2,label='Trottle step')
plt.legend(loc='best')
plt.xlabel('Time (sec)')
plt.ylabel('Response (y)')
plt.show()
