clear all; close all; clc

addpath('apm')

% generate LTI model in MATLAB
% Linear model of a Boeing 747
%  Level flight at 40,000 ft elevation
%  Velocity at 774 ft/sec (0.80 Mach)

% States
%  u - uw (ft/sec) - horizontal velocity - horizontal wind
%  w - ww (ft/sec) - vertical velocity - vertical wind
%  q (crad/sec) - angular velocity
%  theta (crad) - angle from horizontal
% note: crad = 0.01 rad
A = [-0.003  0.039  0.000 -0.322;
     -0.065 -0.319  7.740  0.000;
      0.020 -0.101 -0.429  0.000;
      0.000  0.000  1.000  0.000];
% Inputs
%  e - elevator
%  t - throttle
B = [ 0.010  1.000;
     -0.180 -0.040;
     -1.160  0.598;
      0.000  0.000];
% Outputs
%  u - uw (ft/sec) - horizontal airspeed
%  hdot = -w + u0 * theta with u0 = 774 ft/sec
C = [1  0 0 0;
     0 -1 0 7.74];
D = [0 0;
     0 0];
 
sys = ss(A,B,C,D)
sysd = c2d(sys,1)
step(sys,20)
hold on 
step(sysd,20)

% generate LTI model in APMonitor
apm_lti(sys,'747c');  % continuous
apm_lti(sysd,'747d'); % discrete

% model 747c.apm and 747d.apm are now created
% see other script for simulation and control