from apm import *
import matplotlib
import numpy as np
import matplotlib.pyplot as plt

# Select server
s = 'http://byu.apmonitor.com'

# Application name
a = 'trial'

# Clear previous alication
apm(s,a,'clear all')

# Model and Data files
model_file = 'txy.apm'
data_file = 'txy.csv'

# Load model file
apm_load(s,a,model_file)

# Option to select solver (1=APOPT, 2=BPOPT, 3=IPOPT)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'nlc.max_iter',200)

# Classify parameters and variables
apm_info(s,a,'FV','d12')
apm_info(s,a,'FV','d21')
apm_info(s,a,'MV','p')
apm_info(s,a,'MV','x[1]')
apm_info(s,a,'CV','tc')
apm_info(s,a,'CV','y[1]')

# Load data file
csv_load(s,a,data_file)

# Options
apm_option(s,a,'nlc.csv_read',1)
apm_option(s,a,'nlc.ev_type',1)

# Solve Data reconciliation
apm_option(s,a,'nlc.imode',2)
apm_option(s,a,'d12.status',1)
apm_option(s,a,'d21.status',1)
apm_option(s,a,'tc.fstatus',1)
apm_option(s,a,'y[1].fstatus',1)
output = apm(s,a,'solve')
print(output)

# Display Results in Web Viewer 
url = apm_web_var(s,a)

# Retrieve results
sol = apm_sol(s,a)

# Read measured values
data = csv_data(data_file)

# Display results
plt.figure()
plt.scatter(sol['y[1]'],sol['tc'],c='r',marker='x')
plt.scatter(data['y[1]'],data['tc'],c='b',marker='o')
plt.scatter(data['x[1]'],data['tc'],c='y',marker='o')
plt.legend(['y model','y meas','x meas'])
plt.ylabel('Temperature (degC)')
plt.xlabel('Ethanol Mole Fraction')
plt.axis([0,1,60,75])
plt.show()
