% clear everything
clc; close all; clear all

% load APM libraries
addpath('apm')

% Select server
%server = 'http://byu.apmonitor.com';
server = 'http://xps.apmonitor.com';

% Application name
app = 'vle';

% Clear previous application
apm(server,app,'clear all');

% Load model file
apm_load(server,app,'txy_1965.apm');

% Load data file
csv_load(server,app,'vle_data.csv');

% Option to select solver (1=APOPT, 2=BPOPT, 3=IPOPT)
apm_option(server,app,'nlc.solver',1);
apm_option(server,app,'nlc.max_iter',200);

% Classify parameters and variables
apm_info(server,app,'FV','d12');
apm_info(server,app,'FV','d21');
apm_info(server,app,'MV','P');
apm_info(server,app,'MV','x[1]');
apm_info(server,app,'CV','Tc');
apm_info(server,app,'CV','y[1]');

% Options
apm_option(server,app,'nlc.csv_read',1);
apm_option(server,app,'nlc.ev_type',1);

% Solve Data reconciliation
% imode = 2, Parameter estimation with multiple data sets
apm_option(server,app,'nlc.imode',2);
% set d12 and d21 ON with status = 1
apm_option(server,app,'d12.status',1);
apm_option(server,app,'d21.status',1);
% set feedback status for Tc to ON
apm_option(server,app,'Tc.fstatus',1);
% weight on Temperature in objective function
apm_option(server,app,'Tc.wmeas',20);
% set feedback status for y[1] to ON
apm_option(server,app,'y[1].fstatus',1);
% weight on y[1] in objective function
apm_option(server,app,'y[1].wmeas',2000);

% Solve the parameter estimation
apm(server,app,'solve')

% Display Results in Web Viewer 
url = apm_web(server,app);

% Retrieve data
y = apm_sol(server,app);
z = y.x;

x.meas = z.x1;
P.meas = z.p;
y.model = y.values(:,8);
T.model = y.values(:,7);

% get measured values from CSV data
filename = 'vle_data.csv';
fid = fopen(filename, 'r');
% Parse and read rest of file
ctr = 0;
while(~feof(fid))
   aline = fgetl(fid); 
   if ischar(aline) 
      ctr = ctr + 1;
      data(ctr,:) = parse(aline, ','); 
   else
      break; 
   end
end
fclose(fid);
[n,m] = size(data);
for i = 2:n,
  for j = 1:m,
     data{i,j} = str2num(data{i,j});
  end
end
d = cell2mat(data(2:end,:));
T.meas = d(:,4);
y.meas = d(:,5);

figure(1);
scatter(y.model,T.model,'r.')
hold on;
scatter(y.meas,T.meas,'g.')
scatter(x.meas,T.meas,'b.')
legend('y model','y meas','x meas')
ylabel('Temperature (degC)')
xlabel('Ethanol Mole Fraction')