function [msg] = mpc_init(s,a)

addpath('apm')

apm(s,a,'clear all');

% load model and data
apm_load(s,a,'control.apm');
csv_load(s,a,'control.csv');

% configure MV / CV
apm_info(s,a,'MV','Vin');
apm_info(s,a,'CV','TDegF');

% dynamic control
apm_option(s,a,'nlc.imode',6);

% tune MV
% delta MV movement penalty
apm_option(s,a,'Vin.dcost',0.01);
% penalize voltage use (energy savings)
apm_option(s,a,'Vin.cost',0.01);
% limit MV movement each cycle
apm_option(s,a,'Vin.dmax',100);
% MV limits
apm_option(s,a,'Vin.upper',255);
apm_option(s,a,'Vin.lower',0);

% tune CV
% how fast to reach setpoint
apm_option(s,a,'TDegF.tau',60);
% initial targets
apm_option(s,a,'TDegF.sphi',101);
apm_option(s,a,'TDegF.splo',101);
% trajectory type
apm_option(s,a,'TDegF.tr_init',0);

% let optimizer use MV
apm_option(s,a,'Vin.status',1);
% include CV in objective function
apm_option(s,a,'TDegF.status',1);

% feedback status (whether we have measurements)
apm_option(s,a,'Vin.fstatus',0);
apm_option(s,a,'TDegF.fstatus',1);

% web-viewer option, update every second
apm_option(s,a,'nlc.web_plot_freq',1);

msg = 'initialization complete';

return