function [Vin] = mpc(T_meas,desiredTemp)

persistent controller_initialized
persistent webviewer_opened
persistent s a
persistent last_sp

% start timer
tic;

% initialize controller on first cycle
if isempty(controller_initialized),
    s = 'http://byu.apmonitor.com';
    a = ['control' int2str(10000*rand())];
    msg = mpc_init(s,a);
    disp(msg)
    last_sp = -1;
    controller_initialized = true;
end

% check if setpoint has changed
if desiredTemp~=last_sp,
    % create dead-band +/- 0.2 degF
    sphi = desiredTemp + 1.0;
    splo = desiredTemp - 1.0;
    apm_option(s,a,'TDegF.sphi',sphi);
    apm_option(s,a,'TDegF.splo',splo);
end

% input measurement
apm_meas(s,a,'TdegF',T_meas);

% solve MPC
output = apm(s,a,'solve');

% test for successful solution
if (apm_tag(s,a,'nlc.appstatus')==1),
    % retrieve the first Vin value
    Vin = apm_tag(s,a,'Vin.Newval');
    
    % open web-viewer on first cycle
    if isempty(webviewer_opened),
        apm_web(s,a);
        webviewer_opened = true;
    end
    
else
    % display output for debugging
    disp(output)
    % not successful, set voltage to zero
    Vin = 0;
end

t = toc;

disp(['MPC: T_meas = ' num2str(T_meas) ' Vin = ' num2str(Vin) ' in ' num2str(t) ' sec'])


% wait until next cycle time
cycle_time = 1.0;
wait_time = max(0.01,cycle_time-t);
pause(wait_time)
