function varargout = PID_GUI(varargin)
% PID_GUI MATLAB code for PID_GUI.fig
%      PID_GUI, by itself, creates a new PID_GUI or raises the existing
%      singleton*.
%
%      H = PID_GUI returns the handle to a new PID_GUI or the handle to
%      the existing singleton*.
%
%      PID_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in PID_GUI.M with the given input arguments.
%
%      PID_GUI('Property','Value',...) creates a new PID_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before PID_GUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to PID_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help PID_GUI

% Last Modified by GUIDE v2.5 02-Sep-2014 17:48:48

% Begin initialization code - DO NOT EDIT
clear controller_initialized
clear webviewer_opened
addpath('MatlabCode')
tic % start timer
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @PID_GUI_OpeningFcn, ...
    'gui_OutputFcn',  @PID_GUI_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before PID_GUI is made visible.
function PID_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to PID_GUI (see VARARGIN)

% Choose default command line output for PID_GUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes PID_GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% Create xlabel
xlabel(handles.axes1,'Time','FontWeight','bold','FontSize',14,'Color',[0 0 0]);

% Create ylabel
ylabel(handles.axes1,'Temperature (F)','FontWeight','bold','FontSize',14,'Color',[0 0 0]);

% Create title
title(handles.axes1,'Transistor Temperature','FontSize',15,'Color',[0 0 0]);

% Set y limits
ylim(handles.axes1,[50,180]);

% Turn off all buttons
set(handles.manual_button,'Value',0);
set(handles.control_button,'Value',0);
set(handles.custom_button,'Value',0);


% --- Outputs from this function are returned to the command line.
function varargout = PID_GUI_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in start_button.
function start_button_Callback(hObject, eventdata, handles)
% hObject    handle to start_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in action_button.
function action_button_Callback(hObject, eventdata, handles)
% hObject    handle to action_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of action_button
button_state = get(hObject,'Value');
if button_state == get(hObject,'Max')
    %Clear Previous Data
    cla(handles.axes1);
    clearvars time temperature time_out data_out;
    
    %Switch Button Text
    set(handles.action_button,'String','Stop');
    set(handles.save_text,'Visible','off');
    %%Set up COM Port
    disp('Initializing Connection')
    %     prompt = 'Input Arduino COM Port (ex COM4):';
    %     COM_PORT = input(prompt, 's')
    COM_PORT = FindPort();
    COM_PORT = regexprep(COM_PORT,'[^\w'']','')
    %COM_PORT = 'COM4';
    disp('COM Port Selected')
    disp(COM_PORT)
    delete(instrfind({'Port'},{COM_PORT}))
    
    %%Initialize Arduino Connection
    set(handles.action_button,'String','Connecting...');
    set(handles.action_button,'BackgroundColor','yellow');
    a = arduino(COM_PORT);
    set(handles.action_button,'String','Stop');
    set(handles.action_button,'BackgroundColor','red');
    
    %% Set up the figure window
    time = now;
    startTime = clock;
    temperature = 0;
    output = 0;
    control = 0;
    setPoint = 100;
    outToPlot = 50;
    %figureHandle = figure('NumberTitle','off',...
    %    'Name','Transistor Temperature',...
    %    'Color',[0 0 0],'Visible','off');
    
    % Set axes
    %axesHandle = axes('Parent',figureHandle,...
    %    'YGrid','on',...
    %    'YColor',[0.9725 0.9725 0.9725],...
    %    'XGrid','on',...
    %    'XColor',[0.9725 0.9725 0.9725],...
    %    'Color',[0 0 0]);
    
    %hold on;
    
    plotHandle = plot(handles.axes1,time,temperature,'Marker','.','LineWidth',.25,'Color',[0 1 0]);
    hold on;
    grid on;
    plotHandle2 = plot(handles.axes1,time,setPoint,'Marker','.','LineWidth',.25,'Color','red');
    plotHandle3 = plot(handles.axes1,time,outToPlot,'Marker','.','LineWidth',.25,'Color',[0 0 1]);
    xlim(handles.axes1,[max(time-.05) max(time+0.005)]);
    ylim(handles.axes1,[50,180]);
    
    % Create xlabel
    xlabel('Time','FontWeight','bold','FontSize',14,'Color',[0 0 0]);
    
    % Create ylabel
    ylabel('Temperature (F) / Transistor mV (% Output)','FontWeight','bold','FontSize',14,'Color',[0 0 0]);
    
    % Create title
    title('Transistor Temperature','FontSize',15,'Color',[0 0 0]);
    
    %Legend
    leg = legend('Thermistor Temperature (PV)','Temperature Setpoint (SP)','Transistor Output (OP)');
    legtxt = findobj(leg,'type','text');
    %set(legtxt(1),'color','white');
    %set(legtxt(2),'color','white');
    %% Set the time span and interval for data collection
    %stopTime = addtodate(now,120,'second');
    timeInterval = 0.005;
    
    % Initialize PID Variables
    lastTime = now;
    lastErr = 0;
    lastdPV = 0;
    lastDegF = 80;
    filter = 0.05;
    error = 0;
    errSum = 0;
    out_min = 0;
    out_max = 255;
    out = 0;
    ubias = 0;
    
    % User Variables
    desiredTemp = str2double(get(handles.setpoint,'String'));
    
    if(desiredTemp > 150)
        desiredTemp = 150;
        set(handles.setpoint,'String',num2str(desiredTemp));
    elseif(desiredTemp < 0)
        desiredTemp = 0;
        set(handles.setpoint,'String',num2str(desiredTemp));
    end
    
    kp = str2double(get(handles.kp,'String'));
    ki = str2double(get(handles.ki,'String'));
    lastki = ki;
    kd = str2double(get(handles.kd,'String'));
    
    % Collect data
    count = 1;
    
    disp('Collecting Data Now:::')
    
    %% Loop for manual or control operation
    while button_state == get(hObject,'Max')
        % Refresh Inputs
        desiredTemp = str2double(get(handles.setpoint,'String'));
        
        if(desiredTemp > 150)
            desiredTemp = 150;
            set(handles.setpoint,'String',num2str(desiredTemp));
        elseif(desiredTemp < 0)
            desiredTemp = 0;
            set(handles.setpoint,'String',num2str(desiredTemp));
        end
        
        kp = str2double(get(handles.kp,'String'));
        ki = str2double(get(handles.ki,'String'));
        kd = str2double(get(handles.kd,'String'));
        
        % Check for ki change
        if (ki~=lastki),
            % Reset integrator
            errSum = 0;
            ubias = out - kp * error;
        end
        
        % Calculate Temperature
        setpoint_V = (((desiredTemp-32)/1.8)*10 + 500);
        time(count) = datenum(clock);
        time_out(count) = etime(clock,startTime);
        val = a.analogRead(0);
        voltage = val*(3300/1024);
        DegC = (voltage - 500)/10;
        DegF = DegC*1.8+32;
        temperature(count) = DegF;%((((val*5)/1024.0)-.5)*100)*9/5 + 32;
        setPoint(count) = desiredTemp;
        
        %Temperature Warning
        if DegF > 90
            set(handles.warning,'Visible','on');
        else
            set(handles.warning,'Visible','off');
        end
                
        %% Implement controller based on selected options
        if get(handles.control_button,'Value') == get(handles.control_button,'Max')
            % Control Mode

            % PID Controller Equations
            timeChange = (now - lastTime)*3600*24; % sec
            lastTime = now;
            error = (desiredTemp - DegF);
            errSum = errSum + (error * timeChange);
            dErr = (error - lastErr) / timeChange;
            % filter for derivative term
            dPV_raw = (DegF - lastDegF) / timeChange;
            dPV = filter * dPV_raw + (1-filter) * lastdPV;
            % PID Controller Output
            out = ubias + kp * error + ki * errSum - kd * dPV;
            % Limit Output
            if isnan(out),
                out = 0;
            end
            if out > out_max
                out = out_max;
            end
            if out < out_min
                out = out_min;
            end
            % Anti-reset Wind-up
            if (out<=out_min),
                errSum = errSum - (error * timeChange);
            end
            if (out>=out_max),
                errSum = errSum - (error * timeChange);              
            end
                            
            out = round(out);

            % Save Variables
            lastErr = error;
            lastdPV = dPV;
            
            a.analogWrite(3,out);
            output(count) = out;
            outToPlot(count) = (130/255)*out+50;
            control(count) = 1;
            set(handles.voltage_text,'String',num2str(out));
        elseif get(handles.manual_button,'Value') == get(handles.manual_button,'Max')
            % Manual Mode
            out = str2double(get(handles.output_field,'String'));
            output(count) = out;
            outToPlot(count) = (130/255)*out+50;
            a.analogWrite(3,out);
            control(count) = 2;
            
            % Reset controller
            errSum = 0;
            ubias = out; % for bump-less control
        elseif get(handles.custom_button,'Value') == get(handles.manual_button,'Max')
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%  INSERT CUSTOM CONTROLLER HERE  %%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % Available Variables: 
            % Input:
            % DegF - Latest temperature measurement in F
            % desiredTemp - Current setpoint
            % Output:
            % out - output voltage to arduino board in mV (0-255)
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%Put controller in this space

            %EXAMPLE 1 - Bang Bang Control
            %if(DegF < desiredTemp)
            %    out = 255;
            %else
            %    out = 0;
            %end

            %EXAMPLE 2 - Model Predictive Controller
            out = mpc(DegF,desiredTemp);
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            
            %OUTPUT TO ARDUINO BOARD - DO NOT CHANGE
            out = round(out);
            a.analogWrite(3,out);
            output(count) = out;
            outToPlot(count) = (130/255)*out+50;
            control(count) = 1;
            set(handles.voltage_text,'String',num2str(out));
        else
            % No button selected
            outToPlot(count) = 50;
        end
        
        % Display Line
        disp(['Time: ' num2str(toc,'%8.1f') ...
            ' Voltage (OP): ' num2str(out,'%3.0f') ...
            ' T (degF): ' num2str(DegF,'%6.2f')]);
        
        % Plot
        set(plotHandle,'YData',temperature,'XData',time);
        set(plotHandle2,'YData',setPoint,'XData',time);
        set(plotHandle3,'YData',outToPlot,'XData',time);
        set(handles.temp_display,'String',sprintf('%0.1f',temperature(count)));
        set(handles.axes1,'xlim',[max(time)-.0005 max(time)+.0001]);
        %set(figureHandle,'Visible','on');
        datetick('x','HH:MM:SS','keeplimits');
        
        pause(timeInterval);
        button_state = get(hObject,'Value');
        count = count +1;

        % save values
        lastki = ki;
    end    
    
    disp('Data Collection Complete.');
    disp('Saving Data');
    set(handles.action_button,'String','Saving Data');
    set(handles.action_button,'BackgroundColor','yellow');
    %axes1_pos = get(handles.axes1,'Position');
    %handles.axes2 = axes('Position',axes1_pos,'YAxisLocation','right',);
    set(handles.axes1,'xlim',[min(time)-.0001 max(time)+.0001]);
    
    %Save Output Data
    headers = {'Time(s)','Setpoint(F)','Temperature(F)','Output(mV)','Control Mode'};
    data_out(:,1) = time_out;
    data_out(:,2) = setPoint;
    data_out(:,3) = temperature;
    data_out(:,4) = output;
    data_out(:,5) = control;
    currentTime = TimeStamp();
    csvwrite_with_headers(['Collected Data\PID_Output_',currentTime,'.csv'],data_out,headers);
    
    %Switch Button label back
    pause(.01);
    set(handles.save_text,'Visible','on');
    set(handles.action_button,'String','Start');
    set(handles.action_button,'BackgroundColor',[0 .7 0]);
    disp('Closing Connection.');
    
    a.analogWrite(3,0)
    delete(a)
end


% --- Executes on button press in clear_button.
function clear_button_Callback(hObject, eventdata, handles)
% hObject    handle to clear_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
cla(handles.axes1);



function setpoint_Callback(hObject, eventdata, handles)
% hObject    handle to setpoint (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of setpoint as text
%        str2double(get(hObject,'String')) returns contents of setpoint as a double


% --- Executes during object creation, after setting all properties.
function setpoint_CreateFcn(hObject, eventdata, handles)
% hObject    handle to setpoint (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




function kp_Callback(hObject, eventdata, handles)
% hObject    handle to kp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kp as text
%        str2double(get(hObject,'String')) returns contents of kp as a double


% --- Executes during object creation, after setting all properties.
function kp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ki_Callback(hObject, eventdata, handles)
% hObject    handle to ki (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ki as text
%        str2double(get(hObject,'String')) returns contents of ki as a double


% --- Executes during object creation, after setting all properties.
function ki_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ki (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function kd_Callback(hObject, eventdata, handles)
% hObject    handle to kd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kd as text
%        str2double(get(hObject,'String')) returns contents of kd as a double


% --- Executes during object creation, after setting all properties.
function kd_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes when selected object is changed in mode_panel.
function mode_panel_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in mode_panel
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)
if get(handles.control_button,'Value') == get(handles.control_button,'Max')
    set(handles.setpoint,'Enable','on','Visible','on');
    set(handles.kp,'Enable','on','Visible','on');
    set(handles.ki,'Enable','on','Visible','on');
    set(handles.kd,'Enable','on','Visible','on');
    set(handles.setpoint_text,'Visible','on');
    set(handles.kp_text,'Visible','on');
    set(handles.ki_text,'Visible','on');
    set(handles.kd_text,'Visible','on');
    set(handles.input_message,'Visible','off');
    set(handles.voltage_text,'Visible','on');
    set(handles.output_text,'Visible','on');
end
if get(handles.control_button,'Value') == get(handles.control_button,'Min')
    set(handles.setpoint,'Enable','off','Visible','off');
    set(handles.kp,'Enable','off','Visible','off');
    set(handles.ki,'Enable','off','Visible','off');
    set(handles.kd,'Enable','off','Visible','off');
    set(handles.setpoint_text,'Visible','off');
    set(handles.kp_text,'Visible','off');
    set(handles.ki_text,'Visible','off');
    set(handles.kd_text,'Visible','off');
    set(handles.input_message,'Visible','on');
    set(handles.voltage_text,'Visible','off');
    set(handles.output_text,'Visible','off');
end
if get(handles.manual_button,'Value') == get(handles.control_button,'Max')
    set(handles.output_field,'Enable','on','Visible','on');
    set(handles.output_text,'Visible','on');
    set(handles.input_message,'Visible','off');
end
if get(handles.manual_button,'Value') == get(handles.control_button,'Min')
    set(handles.output_field,'Enable','off','Visible','off');
end
if get(handles.custom_button,'Value') == get(handles.control_button,'Max')
    set(handles.setpoint,'Enable','on','Visible','on');
    set(handles.setpoint_text,'Visible','on');
    set(handles.input_message,'Visible','off');
    set(handles.voltage_text,'Visible','on');
    set(handles.output_text,'Visible','on');
end


function output_field_Callback(hObject, eventdata, handles)
% hObject    handle to output_field (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of output_field as text
%        str2double(get(hObject,'String')) returns contents of output_field as a double
val = str2double(get(handles.output_field,'String'));
val2 = val;
if val > 255
    val2 = 255;
end
if val < 0
    val2 = 0;
end
if val2 ~= val
    set(handles.output_field,'String',num2str(val2));
end

% --- Executes during object creation, after setting all properties.
function output_field_CreateFcn(hObject, eventdata, handles)
% hObject    handle to output_field (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function axes2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate axes2


% --- Executes on mouse press over axes background.
function axes2_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to axes2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object deletion, before destroying properties.
function axes2_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to axes2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
