% compute the objective function
function obj = my_objective(p)

% import data
[td,ud,yd] = my_data;

%% Starting temperature
y0 = ones(3,1) * yd(1);

%% Solve options
options= odeset('MaxStep',1);

%% Integrate model equation
ts = [0];
ys = [y0'];
for i = 2:size(td,1),
    u = ud(i);
    [t,y] = ode15s(@(t,y)my_model(t,y,u,p),[td(i-1) td(i)],y0,options);
    y0 = y(end,:)';
    ts = [ts; t(end)];
    ys = [ys; y(end,:)];
end

T1 = ys(:,1);
T2 = ys(:,2);
T3 = ys(:,3);

% compute sum of squared errors
obj = sum((yd-T3).^2);

disp(['Parameters h:' num2str(p(1)) ' k:' num2str(p(2)) ' Objective Evaluated: ', num2str(obj)])

%% Plot the results
figure(1)

subplot(3,1,1)
hold off
plot(ts,T3,'r-','LineWidth',2)
hold on
plot(td,yd,'b-','LineWidth',2)
legend('Model Output','Measured Output')
ylabel('Output')

subplot(3,1,2)
hold off
plot(ts,T1,'r-','LineWidth',3)
hold on
plot(ts,T2,'g:','LineWidth',2)
plot(ts,T3,'k--','LineWidth',1)
legend('Transistor','Silver Epoxy','Thermistor')
ylabel('Temperature (K)')

subplot(3,1,3)
hold off
plot(td,ud,'k-.','LineWidth',2)
ylabel('Input (mV)')
legend('Input')

xlabel('Time (sec)')
title('Simulation Results')
