function ydot = my_model(t,y,ud,p)


%% Include your model equations here ----------------------

% Parameters or inputs
h = p(1);    % heat transfer coefficient
k = p(2);    % thermal conductivity

Ta = (80-32)*5/9 + 273.15;  % 80 degF in K = Ambient temperature
A1 = 5 / 100^2;    % Area in m^2
A2 = 0.5 / 100^2;  % Area in m^2
A3 = 0.5 / 100^2;  % Area in m^2
Ac = 0.5 / 100^2;  % Cross sectional area = 0.5 cm^2 in m^2
dx = 0.5 / 100;    % Length in m
Amp = 1;           % Amps to Transitor
m1 = 3   / 1000;   % Mass 1 in kg
m2 = 1 / 1000;     % Mass 2 in kg
m3 = 0.25 / 1000;  % Mass 3 in kg
Cp1 = 0.49 * 1000; % Heat capacity of steel (J/kg-K)
Cp2 = 0.23 * 1000; % Heat capacity of silver (J/kg-K)
Cp3 = 1.67 * 1000; % Heat capacity of plastic (J/kg-K)

% Temperatures (K)
% y(1) = Temperature of transistor (heating element)
% y(2) = Temperature of silver epoxy
% y(3) = Temperature of thermistor (sensor)
T1 = y(1,1);
T2 = y(2,1);
T3 = y(3,1);

%% Equations
% acc = inlet - outlet
dT1dt = (1/(m1*Cp1))*(-h*A1*(T1-Ta) - (k*Ac/dx)*(T1-T2) + Amp*ud/1000);
dT2dt = (1/(m2*Cp2))*(-h*A2*(T2-Ta) + (k*Ac/dx)*(T1-T2) - (k*Ac/dx)*(T2-T3));
dT3dt = (1/(m3*Cp3))*(-h*A3*(T3-Ta) + (k*Ac/dx)*(T2-T3));

%% End model equations ------------------------------------

%% Outputs
% dy/dt = function(y,u)
ydot = [dT1dt; dT2dt; dT3dt];
