%% Clear everything
clear all; close all; clc

%% Turn off warnings
warning('off','all');

%% Parameter initial guesses
h0 = 1;  % W/m^2-K
k0 = 1; % W/m-K
p0 = [h0 k0];
lb = [1 1];
ub = [100 100];

% Find optimal values of p
p = fmincon(@my_objective,p0,[],[],[],[],lb,ub);

% Report best solution
disp(['Parameter values:' num2str(p)])

%% Load Data
[td,ud,yd] = my_data;

%% Starting temperature
y0 = ones(3,1) * yd(1);

%% Solve options
options= odeset('MaxStep',1);

%% Integrate model equations
ts = [0];
ys = [y0'];
for i = 2:size(td,1),
    u = ud(i);
    [t,y] = ode15s(@(t,y)my_model(t,y,u,p),[td(i-1) td(i)],y0,options);
    y0 = y(end,:)';
    ts = [ts; t(end)];
    ys = [ys; y(end,:)];
end

T1 = ys(:,1);
T2 = ys(:,2);
T3 = ys(:,3);

%% Plot the results
figure(1)

subplot(3,1,1)
plot(ts,T3,'r-','LineWidth',2)
hold on
plot(td,yd,'b-','LineWidth',2)
legend('Model Output','Measured Output')
ylabel('Output')

subplot(3,1,2)
plot(ts,T1,'r-','LineWidth',3)
hold on
plot(ts,T2,'g:','LineWidth',2)
plot(ts,T3,'k--','LineWidth',1)
legend('Transistor','Silver Epoxy','Thermistor')
ylabel('Temperature (K)')

subplot(3,1,3)
plot(td,ud,'k-.','LineWidth',2)
ylabel('Input (mV)')
legend('Input')

xlabel('Time (sec)')
title('Simulation Results')
