% Load the data
function [td,ud,yd] = my_data

% change filename
filename = 'PID_Output.csv';

% read data
warning('off','all');
T = readtable(filename,'Delimiter',',','Format','%f%f%f%f%f');

% put data into row vectors
td = T.Time_s_ - T.Time_s_(1);
ud = T.Output_mV_;
Tk = (T.Temperature_F_ - 32.0) * 5/9 + 273.15;
yd = Tk;

% write data to CSV file for APMonitor
% open a file for writing without temperature data
fid = fopen('arduino.csv', 'w');
% write a header
fprintf(fid, 'time,v\n');
% write data
fprintf(fid, '%f, %f\n', td(1),ud(1));
for i = 2:size(td,1)-1,
    % down-sample to every 10th point, including any changes
    if ((ud(i)~=ud(i+1)) || (ud(i)~=ud(i-1)) || mod(i,10)==0),
        fprintf(fid, '%f, %f\n', td(i),ud(i));
    end
end
fclose(fid);

% open a file for writing for fitting (with temperature data)
fid = fopen('arduino_fit.csv', 'w');
% write a header
fprintf(fid, 'time,v,T3\n');
% write data
fprintf(fid, '%f, %f,  %f\n', td(1),ud(1),yd(1));
for i = 2:size(td,1)-1,
    % down-sample to every 10th point, including any changes
    if ((ud(i)~=ud(i+1)) || (ud(i)~=ud(i-1)) || mod(i,10)==0),
        fprintf(fid, '%f, %f,  %f\n', td(i),ud(i),yd(i));
    end
end
fclose(fid);

