%% Clear all variables, close plots, clear command screen
clear all; close all; clc
addpath('apm')

% load data
[td,ud,yd] = my_data;

% solve model
s = 'http://byu.apmonitor.com';
a = ['Arduino' int2str(rand()*1000)];
apm(s,a,'clear all');
apm_load(s,a,'arduino.apm'); % load model
csv_load(s,a,'arduino_fit.csv'); % load data
% declare which parameters to estimate
apm_info(s,a,'FV','h');
apm_info(s,a,'FV','k');
apm_option(s,a,'h.status',1);
apm_option(s,a,'k.status',1);
% bounds for parameters
apm_option(s,a,'h.upper',100);
apm_option(s,a,'h.lower',1);
apm_option(s,a,'k.upper',100);
apm_option(s,a,'k.lower',1);
% declare which states to fit
apm_info(s,a,'CV','T3');
apm_option(s,a,'T3.fstatus',1);
apm_info(s,a,'MV','v');
% a few other options
apm_option(s,a,'nlc.imode',5); % dynamic estimation
% solve parameter estimation problem
output = apm(s,a,'solve');
disp(output)
% retrieve solution
y = apm_sol(s,a);
z = y.x;
% print new parameters
h = apm_tag(s,a,'h.newval');
k = apm_tag(s,a,'k.newval');
disp(['New Parameters are h: ' num2str(h) ' and k: ' num2str(k)])
apm_web(s,a)

%% Plot the results
figure(1)

subplot(3,1,1)
plot(z.time,z.t3,'r-','LineWidth',2)
hold on
plot(td,yd,'b-','LineWidth',2)
legend('Model Output','Measured Output')
ylabel('Output')

subplot(3,1,2)
plot(z.time,z.t1,'r-','LineWidth',3)
hold on
plot(z.time,z.t2,'g:','LineWidth',2)
plot(z.time,z.t3,'k--','LineWidth',1)
legend('Transistor','Silver Epoxy','Thermistor')
ylabel('Temperature (K)')

subplot(3,1,3)
plot(td,ud,'k-.','LineWidth',2)
ylabel('Input (mV)')
legend('Input')

xlabel('Time (sec)')
title('Simulation Results')
