%% Clear all variables, close plots, clear command screen
clear all; close all; clc
addpath('apm')

% load data
[td,ud,yd] = my_data;

% solve model
y = apm_solve('arduino',7);
z = y.x;


%% Plot the results
figure(1)

subplot(3,1,1)
plot(z.time,z.t3,'r-','LineWidth',2)
hold on
plot(td,yd,'b-','LineWidth',2)
legend('Model Output','Measured Output')
ylabel('Output')

subplot(3,1,2)
plot(z.time,z.t1,'r-','LineWidth',3)
hold on
plot(z.time,z.t2,'g:','LineWidth',2)
plot(z.time,z.t3,'k--','LineWidth',1)
legend('Transistor','Silver Epoxy','Thermistor')
ylabel('Temperature (K)')

subplot(3,1,3)
plot(td,ud,'k-.','LineWidth',2)
ylabel('Input (mV)')
legend('Input')

xlabel('Time (sec)')
title('Simulation Results')
