%% Clear worksession
clear all; close all; clc

%% Input FOPDT from empirical fit
s = tf('s');
fopdt = 0.21 / (300 * s + 1) * exp(-20*s);

%% Input model parameters
h = 6;    % heat transfer coefficient
k = 20;    % thermal conductivity
Ta = (80-32)*5/9 + 273.15;  % 80 degF in K = Ambient temperature
A1 = 5 / 100^2;    % Area in m^2
A2 = 0.5 / 100^2;  % Area in m^2
A3 = 0.5 / 100^2;  % Area in m^2
Ac = 0.5 / 100^2;  % Cross sectional area = 0.5 cm^2 in m^2
dx = 0.5 / 100;    % Length in m
Amp = 1;           % Amps to Transitor
m1 = 3   / 1000;   % Mass 1 in kg
m2 = 1 / 1000;     % Mass 2 in kg
m3 = 0.25 / 1000;  % Mass 3 in kg
Cp1 = 0.49 * 1000; % Heat capacity of steel (J/kg-K)
Cp2 = 0.23 * 1000; % Heat capacity of silver (J/kg-K)
Cp3 = 1.67 * 1000; % Heat capacity of plastic (J/kg-K)
V = 0;

%% Convert 3-state model to state space form
%dT1dt = (1/(m1*Cp1))*(-h*A1*(T1-Ta) - (k*Ac/dx)*(T1-T2) + Amp*ud/1000);
A(1,1) = (1/(m1*Cp1))*(-h*A1-k*Ac/dx);
A(1,2) = (1/(m1*Cp1))*(k*Ac/dx);
A(1,3) = 0;
B(1,1) = (1/(m1*Cp1)) * Amp/1000;
%dT2dt = (1/(m2*Cp2))*(-h*A2*(T2-Ta) + (k*Ac/dx)*(T1-T2) - (k*Ac/dx)*(T2-T3));
A(2,1) = (1/(m2*Cp2))*(k*Ac/dx);
A(2,2) = (1/(m2*Cp2))*(-h*A2-2*k*Ac/dx);
A(2,3) = (1/(m2*Cp2))*(k*Ac/dx);
B(2,1) = 0;
%dT3dt = (1/(m3*Cp3))*(-h*A3*(T3-Ta) + (k*Ac/dx)*(T2-T3));
A(3,1) = 0;
A(3,2) = (1/(m3*Cp3))*(k*Ac/dx);
A(3,3) = (1/(m3*Cp3))*(-h*A3-k*Ac/dx);
B(3,1) = 0;
% other matrices
C = [0 0 1]; % measure the 3rd state
D = 0;

% state-space model
sys_ss = ss(A,B,C,D);
% transfer function form (continuous)
sys_tf = tf(sys_ss);
% transfer function form (discrete)
sys_d  = c2d(sys_tf,50);

figure(1)
step(sys_ss)
hold on
step(sys_tf)
step(sys_d)
step(fopdt)