% compute the objective function
function obj = my_objective(p)

% import data
[td,ud,yd] = my_data;

%% Starting temperature
T0 = yd(1);

%% Solve options
options= odeset('MaxStep',1);

%% Integrate model equation
ts = [0];
ys = [T0];
for i = 2:size(td,1),
    u = ud(i);
    [t,y] = ode15s(@(t,y)my_model(t,y,u,p),[td(i-1) td(i)],T0,options);
    T0 = y(end);
    ts = [ts; t(end)];
    ys = [ys; y(end)];
end

T = ys;

% compute sum of squared errors
obj = sum((yd-T).^2);

disp(['Parameters h:' num2str(p(1)) ...
    ' m:' num2str(p(2)) ...
    ' Cp: ' num2str(p(3)) ...
    ' Objective: ', num2str(obj)])

%% Plot the results
figure(1)

subplot(2,1,1)
hold off
plot(ts,T,'r-','LineWidth',2)
hold on
plot(td,yd,'b-','LineWidth',2)
legend('Model Output','Measured Output')
ylabel('Output')

subplot(2,1,2)
hold off
plot(td,ud,'k-.','LineWidth',2)
ylabel('Input (mV)')
legend('Input')

xlabel('Time (sec)')
title('Simulation Results')
