function dTdt = my_model(t,T,ud,p)

% Parameters or inputs
h = p(1);    % heat transfer coefficient
m = p(2);    % mass in kg
Cp = p(3); % Heat capacity (J/kg-K)

Ta = (80-32)*5/9 + 273.15;  % 80 degF in K = Ambient temperature
A = 6 / 100^2;    % Area in m^2
Amp = 1;           % Amps to Transitor

% acc = inlet - outlet
dTdt = (1/(m*Cp))*(-h*A*(T-Ta) + Amp*ud/1000);
