% Load the data
function [td,ud,yd] = my_data

% change filename
filename = 'PID_Output.csv';

% read data
T = readtable(filename,'Delimiter',',','Format','%f%f%f%f%f');

% put data into row vectors
td = T.Time_s_ - T.Time_s_(1);
% check for repeat time values
for i = 2:size(td,1)-1,
    if (td(i)<=td(i-1)),
        td(i) = td(i-1)+1e-5;
    end
end
ud = T.Output_mV_;
Tk = (T.Temperature_F_ - 32.0) * 5/9 + 273.15;
yd = Tk;
