%% Clear everything
clear all; close all; clc

%% Turn off warnings
warning('off','all');

%% Parameter initial guesses
h0 = 1; % W/m^2-K
m0 = 4/1000; % kg
Cp0 = 0.5 * 1000; % J/kg-K
% initial parameters
p0 = [h0 m0 Cp0];
% lower bounds
lb = [1 1/1000 200];
% upper bounds
ub = [100 10/1000 1000];

% Find optimal values of p
p = fmincon(@my_objective,p0,[],[],[],[],lb,ub);

% Report best solution
disp(['Parameter values:' num2str(p)])

%% Load Data
[td,ud,yd] = my_data;

%% Starting temperature
y0 = yd(1);

%% Solve options
options= odeset('MaxStep',1);

%% Integrate model equations
ts = [0];
ys = [y0];
for i = 2:size(td,1),
    u = ud(i);
    [t,y] = ode15s(@(t,y)my_model(t,y,u,p),[td(i-1) td(i)],y0,options);
    y0 = y(end);
    ts = [ts; t(end)];
    ys = [ys; y(end)];
end

T = ys;

%% Plot the results
figure(1)

subplot(2,1,1)
plot(ts,T,'r-','LineWidth',2)
hold on
plot(td,yd,'b-','LineWidth',2)
legend('Model Output','Measured Output')
ylabel('Output')

subplot(2,1,2)
plot(td,ud,'k-.','LineWidth',2)
ylabel('Input (mV)')
legend('Input')

xlabel('Time (sec)')
title('Simulation Results')
