%% Clear all variables, close plots, clear command screen
clear all; close all; clc
addpath('apm')

% load data
[td,ud,yd] = my_data;

% solve model
s = 'http://byu.apmonitor.com';
a = ['Arduino' int2str(rand()*1000)];
apm(s,a,'clear all');
apm_load(s,a,'arduino.apm'); % load model
csv_load(s,a,'arduino_fit.csv'); % load data
% declare which parameters to estimate
apm_info(s,a,'FV','h');
apm_info(s,a,'FV','m');
apm_info(s,a,'FV','Cp');
apm_option(s,a,'h.status',1);
apm_option(s,a,'m.status',1);
apm_option(s,a,'Cp.status',1);
% bounds for parameters
apm_option(s,a,'h.upper',100);
apm_option(s,a,'h.lower',1);
apm_option(s,a,'m.upper',0.010);
apm_option(s,a,'m.lower',0.001);
apm_option(s,a,'Cp.upper',1000);
apm_option(s,a,'Cp.lower',200);
% declare which states to fit
apm_info(s,a,'CV','T');
apm_option(s,a,'T.fstatus',1);
apm_info(s,a,'MV','v');
% a few other options
apm_option(s,a,'nlc.imode',5); % dynamic estimation
% solve parameter estimation problem
output = apm(s,a,'solve');
disp(output)
% retrieve solution
y = apm_sol(s,a);
z = y.x;
% print new parameters
h = apm_tag(s,a,'h.newval');
m = apm_tag(s,a,'m.newval');
Cp = apm_tag(s,a,'cp.newval');
disp(['New Parameters are h: ' num2str(h) ' m: ' num2str(m) ' Cp: ' num2str(Cp)])
apm_web(s,a)

%% Plot the results
figure(1)

subplot(2,1,1)
plot(z.time,z.t,'r-','LineWidth',2)
hold on
plot(td,yd,'b-','LineWidth',2)
legend('Model Output','Measured Output')
ylabel('Output')

subplot(2,1,2)
plot(td,ud,'k-.','LineWidth',2)
ylabel('Input (mV)')
legend('Input')

xlabel('Time (sec)')
title('Simulation Results')
