%% Clear all variables, close plots, clear command screen
clear all; close all; clc
addpath('apm')

% load data
[td,ud,yd] = my_data;

% solve model
y = apm_solve('arduino',7);
z = y.x;


%% Plot the results
figure(1)

subplot(2,1,1)
plot(z.time,z.t,'r-','LineWidth',2)
hold on
plot(td,yd,'b-','LineWidth',2)
legend('Model Output','Measured Output')
ylabel('Output')

subplot(2,1,2)
plot(td,ud,'k-.','LineWidth',2)
ylabel('Input (mV)')
legend('Input')

xlabel('Time (sec)')
title('Simulation Results')
