%% Clear worksession
clear all; close all; clc

%% Input FOPDT from empirical fit
s = tf('s');
Kp = 0.21;   % degF / mV
taup = 200;  % sec
thetap = 20; % sec
fopdt = Kp / (taup * s + 1) * exp(-thetap*s);

%% Input model parameters
h = 6;     % heat transfer coefficient
k = 20;    % thermal conductivity
Cp = 500;  % Heat capacity (J/kg-K)
m = 4/1000 % Mass (kg)
Ta = (80-32)*5/9 + 273.15;  % 80 degF in K = Ambient temperature
A = 6 / 100^2;    % Area in m^2
Amp = 1;           % Amps to Transitor

%% Convert 1-state model to state space form
%dTdt = (1/(m*Cp))*(-h*A*(T-Ta) + Amp*ud/1000);
A(1,1) = (1/(m*Cp))*(-h*A);
B(1,1) = (1/(m*Cp)) * Amp/1000;
C = 1;
D = 0;

% state-space model
sys_ss = ss(A,B,C,D);
% transfer function form (continuous)
sys_tf = tf(sys_ss);
% transfer function form (discrete)
sys_d  = c2d(sys_tf,1);

figure(1)
step(sys_ss)
hold on
step(sys_tf)
step(sys_d)
step(fopdt)