function varargout = PID_GUI(varargin)
% PID_GUI MATLAB code for PID_GUI.fig
%      PID_GUI, by itself, creates a new PID_GUI or raises the existing
%      singleton*.
%
%      H = PID_GUI returns the handle to a new PID_GUI or the handle to
%      the existing singleton*.
%
%      PID_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in PID_GUI.M with the given input arguments.
%
%      PID_GUI('Property','Value',...) creates a new PID_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before PID_GUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to PID_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help PID_GUI

% Last Modified by Jeffrey Griffiths 2015-06-16-13h17m42s

% Begin initialization code - DO NOT EDIT
addpath('MatlabCode')
tic % start timer
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @PID_GUI_OpeningFcn, ...
    'gui_OutputFcn',  @PID_GUI_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before PID_GUI is made visible.
function PID_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to PID_GUI (see VARARGIN)

% Choose default command line output for PID_GUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes PID_GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% Create xlabel
xlabel(handles.axes1,'Time','FontWeight','bold','FontSize',14,'Color',[0 0 0]);

% Create ylabel
ylabel(handles.axes1,'Temperature (F)','FontWeight','bold','FontSize',14,'Color',[0 0 0]);

% Create title
title(handles.axes1,'Transistor Temperature','FontSize',15,'Color',[0 0 0]);

% Set y limits
ylim(handles.axes1,[50,180]);

% Turn off all buttons
set(handles.manual_button,'Value',0);
set(handles.control_button,'Value',0);
set(handles.custom_button,'Value',0);


% --- Outputs from this function are returned to the command line.
function varargout = PID_GUI_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in start_button.
function start_button_Callback(hObject, eventdata, handles)
% hObject    handle to start_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in action_button.
function action_button_Callback(hObject, eventdata, handles)
% hObject    handle to action_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of action_button
button_state = get(hObject,'Value');
if button_state == get(hObject,'Max')
    %Clear Previous Data
    cla(handles.axes1);
    clearvars time temperature time_out data_out;
    
    %Switch Button Text
    set(handles.action_button,'String','Stop');
    set(handles.save_text,'Visible','off');
    %%Set up COM Port
    disp('Initializing Connection')
    %     prompt = 'Input Arduino COM Port (ex COM4):';
    %     COM_PORT = input(prompt, 's')
    % For a PC:
    mac = false;
    if ~mac,
        COM_PORT = FindPort();
    else
        % For a Mac, plug the Arduino in and type the following into the terminal:
        % ls /dev/tty*
        % Then copy the line that looks like the one below and put it below
        COM_PORT = '/dev/tty.usbmodem1411';
    end
    disp('COM Port Selected')
    disp(COM_PORT)
    delete(instrfind({'Port'},{COM_PORT}))
    
    %%Initialize Arduino Connection
    set(handles.action_button,'String','Connecting...');
    set(handles.action_button,'BackgroundColor','yellow');
    a = arduino(COM_PORT);
    set(handles.action_button,'String','Stop');
    set(handles.action_button,'BackgroundColor','red');
    
    %% Set up the figure window
    time = now;
    startTime = clock;
    temperature1 = 0;
    temperature2 = 0;
    output1 = 0;
    output2 = 0;
    control = 0;
    setPoint1 = 100;
    setPoint2 = 100;
    outToPlot1 = 50;
    outToPlot2 = 50;
    % Points with which the estimator can work
    tau1 = 144;            % Time constant for unit 1 (sec)
    tau2 = 163;            % Time constant for unit 2 (sec)
    K11 = 0.336;           % Gain for unit 1 with input 1 (del_T/del_V)
    K12 = 0.160;           % Gain for unit 1 with input 2 (del_T/del_V)
    K22 = 0.191;           % Gain for unit 2 with input 2 (del_T/del_V)
    K21 = 0.0812;          % Gain for unit 2 with input 1 (del_T/del_V)
    %figureHandle = figure('NumberTitle','off',...
    %    'Name','Transistor Temperature',...
    %    'Color',[0 0 0],'Visible','off');
    
    % Set axes
    %axesHandle = axes('Parent',figureHandle,...
    %    'YGrid','on',...
    %    'YColor',[0.9725 0.9725 0.9725],...
    %    'XGrid','on',...
    %    'XColor',[0.9725 0.9725 0.9725],...
    %    'Color',[0 0 0]);
    
    %hold on;
    
    plotHandlea = plot(handles.axes1,time,temperature1,'Marker','.','LineWidth',.25,'Color',[0 1 0]);
    hold on;
    grid on;
    plotHandleb = plot(handles.axes1,time,temperature2,'Marker','*','LineWidth',.25,'Color',[0 1 0]);
    plotHandle2a = plot(handles.axes1,time,setPoint1,'Marker','.','LineWidth',.25,'Color','red');
    plotHandle2b = plot(handles.axes1,time,setPoint2,'Marker','*','LineWidth',.25,'Color','red');
    plotHandle3a = plot(handles.axes1,time,outToPlot1,'Marker','.','LineWidth',.25,'Color',[0 0 1]);
    plotHandle3b = plot(handles.axes1,time,outToPlot2,'Marker','*','LineWidth',.25,'Color',[0 0 1]);
    xlim(handles.axes1,[max(time-.05) max(time+0.005)]);
    ylim(handles.axes1,[50,180]);
    
    % Create xlabel
    xlabel('Time','FontWeight','bold','FontSize',14,'Color',[0 0 0]);
    
    % Create ylabel
    ylabel('Temperature (F) / Transistor mV (% Output)','FontWeight','bold','FontSize',14,'Color',[0 0 0]);
    
    % Create title
    title('Transistor Temperature','FontSize',15,'Color',[0 0 0]);
    
    %Legend
    leg = legend('Thermistor Temperature 1 (PV)','Thermistor Temperature 2 (PV)',...
        'Temperature Setpoint 1 (SP)','Temperature Setpoint 2 (SP)',...
        'Transistor Output 1 (OP)','Transistor Output 2 (OP)');
    legtxt = findobj(leg,'type','text');
    %set(legtxt(1),'color','white');
    %set(legtxt(2),'color','white');
    %% Set the time span and interval for data collection
    %stopTime = addtodate(now,120,'second');
    timeInterval = 0.005;
    
    % Initialize PID Variables
    lastTime = now;
    lastErr = 0;
    lastdPV = 0;
    lastDegF = 80;
    filter = 0.05;
    error = 0;
    errSum = 0;
    out_min = 0;
    out_max = 255;
    out1 = 0;
    out2 = 0;
    ubias = 0;
    parameters = zeros(1,6);  % Change to 10 if you use deadtime
    
    % User Variables
    desiredTemp1 = str2double(get(handles.setpoint1,'String'));
    desiredTemp2 = str2double(get(handles.setpoint2,'String'));
    
    if(desiredTemp1 > 150)
        desiredTemp1 = 150;
        set(handles.setpoint1,'String',num2str(desiredTemp1));
    elseif(desiredTemp1 < 0)
        desiredTemp1 = 0;
        set(handles.setpoint1,'String',num2str(desiredTemp1));
    end
    
    if(desiredTemp2 > 150)
        desiredTemp2 = 150;
        set(handles.setpoint2,'String',num2str(desiredTemp2));
    elseif(desiredTemp2 < 0)
        desiredTemp2 = 0;
        set(handles.setpoint2,'String',num2str(desiredTemp2));
    end
    
    kp = str2double(get(handles.kp,'String'));
    ki = str2double(get(handles.ki,'String'));
    lastki = ki;
    kd = str2double(get(handles.kd,'String'));
    
    % Collect data
    count = 1;
    
    disp('Collecting Data Now:::')
    
    %% Loop for manual or control operation
    while button_state == get(hObject,'Max')
        % Refresh Inputs
        desiredTemp1 = str2double(get(handles.setpoint1,'String'));
        desiredTemp2 = str2double(get(handles.setpoint2,'String'));
        
        if(desiredTemp1 > 150)
            desiredTemp1 = 150;
            set(handles.setpoint1,'String',num2str(desiredTemp1));
        elseif(desiredTemp1 < 0)
            desiredTemp1 = 0;
            set(handles.setpoint1,'String',num2str(desiredTemp1));
        end
        
        if(desiredTemp2 > 150)
            desiredTemp2 = 150;
            set(handles.setpoint2,'String',num2str(desiredTemp2));
        elseif(desiredTemp2 < 0)
            desiredTemp2 = 0;
            set(handles.setpoint2,'String',num2str(desiredTemp2));
        end
        
        kp = str2double(get(handles.kp,'String'));
        ki = str2double(get(handles.ki,'String'));
        kd = str2double(get(handles.kd,'String'));
        
        % Check for ki change
        if (ki~=lastki),
            % Reset integrator
            errSum = 0;
            ubias = out1 - kp * error;
        end
        
        % Calculate Temperature
        setpoint_V1 = (((desiredTemp1-32)/1.8)*10 + 500);
        setpoint_V2 = (((desiredTemp2-32)/1.8)*10 + 500);
        time(count) = datenum(clock);
        time_out(count) = etime(clock,startTime);
        val1 = a.analogRead(0);
        val2 = a.analogRead(2);
        voltage1 = val1*(3300/1024);
        voltage2 = val2*(3300/1024);
        DegC1 = (voltage1 - 500)/10;
        DegC2 = (voltage2 - 500)/10;
        DegF1 = DegC1*1.8+32;
        DegF2 = DegC2*1.8+32;
        temperature1(count) = DegF1;%((((val*5)/1024.0)-.5)*100)*9/5 + 32;
        temperature2(count) = DegF2;%((((val*5)/1024.0)-.5)*100)*9/5 + 32;
        setPoint1(count) = desiredTemp1;
        setPoint2(count) = desiredTemp2;
        
        %Temperature Warning
        if DegF1 > 90
            set(handles.warning,'Visible','on');
        else
            set(handles.warning,'Visible','off');
        end
        
        %% Implement controller based on selected options
        if get(handles.control_button,'Value') == get(handles.control_button,'Max')
            % Control Mode
            
            % PID Controller Equations
            %timeChange = (now - lastTime)*3600*24; % sec
            %lastTime = now;
            %error = (desiredTemp - DegF);
            %errSum = errSum + (error * timeChange);
            %dErr = (error - lastErr) / timeChange;
            % filter for derivative term
            %dPV_raw = (DegF - lastDegF) / timeChange;
            %dPV = filter * dPV_raw + (1-filter) * lastdPV;
            % PID Controller Output
            %out1 = ubias + kp * error + ki * errSum - kd * dPV;
            % Limit Output
            %if isnan(out1),
            %    out1 = 0;
            %end
            %if out1 > out_max
            %    out1 = out_max;
            %end
            %if out1 < out_min
            %    out1 = out_min;
            %end
            % Anti-reset Wind-up
            %if (out1<=out_min),
            %    errSum = errSum - (error * timeChange);
            %end
            %if (out1>=out_max),
            %    errSum = errSum - (error * timeChange);
            %end
            
            %out1 = round(out1);
            
            % Save Variables
            %lastErr = error;
            %lastdPV = dPV;
            
            %a.analogWrite(3,out1);
            %output(count) = out1;
            %outToPlot(count) = (130/255)*out1+50;
            %control(count) = 1;
            %set(handles.voltage_text,'String',num2str(out1));
        elseif get(handles.manual_button,'Value') == get(handles.manual_button,'Max')
            % Manual Mode
            out1 = str2double(get(handles.output_field1,'String'));
            out2 = str2double(get(handles.output_field2,'String'));
            output1(count) = out1;
            output2(count) = out2;
            outToPlot1(count) = (130/255)*out1+50;
            outToPlot2(count) = (130/255)*out2+50;
            a.analogWrite(3,out1);
            a.analogWrite(4,out2);
            control(count) = 2;
            
            % Reset controller
            errSum = 0;
            ubias = out1; % for bump-less control
        elseif get(handles.custom_button,'Value') == get(handles.manual_button,'Max')
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%  INSERT CUSTOM CONTROLLER HERE  %%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            
            % Available Variables:
            % Input:
            % DegF1 and DegF2               - Latest temperature measurement in F
            % desiredTemp1 and desiredTemp2 - Current setpoint
            % Output:
            % out1 and out2                 - output voltage to arduino board in mV (0-255)
            
            % Model Predictive Controller
            addpath('Controller')
            %param_mpc = [tau1 tau2 K11 K12 K22 K21];
            %A = mpc(param_mpc,DegF1,DegF2,desiredTemp1,desiredTemp2);
            A = mpc(DegF1,DegF2,desiredTemp1,desiredTemp2);
            out1 = A(1);
            out2 = A(2);
            
            %OUTPUT TO ARDUINO BOARD - DO NOT CHANGE
            out1 = round(out1);
            out2 = round(out2);
            a.analogWrite(3,out1);
            a.analogWrite(4,out2);
            output1(count) = out1;
            output2(count) = out2;
            outToPlot1(count) = (130/255)*out1+50;
            outToPlot2(count) = (130/255)*out2+50;
            control(count) = 1;
            set(handles.voltage_text1,'String',num2str(out1));
            set(handles.voltage_text2,'String',num2str(out2));
        else
            % No button selected
            outToPlot1(count) = 50;
            outToPlot2(count) = 50;
        end
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%  INSERT ESTIMATOR HERE  %%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        % Available Variables:
        % Input:
        % DegF1 and DegF2       - Latest temperature measurement in F
        % out1 and out2         - output voltage to arduino board in mV (0-255)
        % Output:
        
        % tau1 and tau2         - Time constants for FOPDT model
        % K11, K12, K22, K21    - Gain for FOPDT model
        
        % Moving Horizon Estimator
        if get(handles.mhe,'Value') == get(handles.mhe,'Max')
            addpath('Estimator');
            [tau1 tau2 K11 K12 K22 K21] = mhe(DegF1,DegF2,out1,out2);
            parameters(count,:) = [tau1 tau2 K11 K12 K22 K21];
            medians = [median(parameters(:,3)) median(parameters(:,4)) median(parameters(:,5)) median(parameters(:,6))];
        end
        
        % Add a new row to be filled in the next iteration
        parameters = [parameters; zeros(1,6)];
        
        % Display Line
        disp(['Time: ' num2str(toc,'%8.1f') ...
            ' Voltage 1 (OP): ' num2str(out1,'%3.0f') ...
            ' Voltage 2 (OP): ' num2str(out2,'%3.0f') ...
            ' T1 (degF): ' num2str(DegF1,'%6.2f') ...
            ' T2 (degF): ' num2str(DegF2,'%6.2f')]);
        
        % Plot
        set(plotHandlea,'YData',temperature1,'XData',time);
        set(plotHandleb,'YData',temperature2,'XData',time);
        set(plotHandle2a,'YData',setPoint1,'XData',time);
        set(plotHandle2b,'YData',setPoint2,'XData',time);
        set(plotHandle3a,'YData',outToPlot1,'XData',time);
        set(plotHandle3b,'YData',outToPlot2,'XData',time);
        set(handles.temp_display1,'String',sprintf('%0.1f',temperature1(count)));
        set(handles.temp_display2,'String',sprintf('%0.1f',temperature2(count)));
        set(handles.axes1,'xlim',[max(time)-.0005 max(time)+.0001]);
        if get(handles.mhe,'Value') == get(handles.mhe,'Max')
            set(handles.K11r,'String',num2str(K11));
            set(handles.K12r,'String',num2str(K12));
            set(handles.K22r,'String',num2str(K22));
            set(handles.K21r,'String',num2str(K21));
            set(handles.K11m,'String',num2str(medians(1,1)));
            set(handles.K12m,'String',num2str(medians(1,2)));
            set(handles.K22m,'String',num2str(medians(1,3)));
            set(handles.K21m,'String',num2str(medians(1,4)));
        end
        %set(figureHandle,'Visible','on');
        datetick('x','HH:MM:SS','keeplimits');
        
        pause(timeInterval);
        button_state = get(hObject,'Value');
        count = count +1;
        
        % save values
        lastki = ki;
    end
    
    disp('Data Collection Complete.');
    disp('Saving Data');
    set(handles.action_button,'String','Saving Data');
    set(handles.action_button,'BackgroundColor','yellow');
    %axes1_pos = get(handles.axes1,'Position');
    %handles.axes2 = axes('Position',axes1_pos,'YAxisLocation','right',);
    set(handles.axes1,'xlim',[min(time)-.0001 max(time)+.0001]);
    
    %Save Output Data
    headers = {'Time(s)','Setpoint1(F)','Setpoint2(F)','Temperature1(F)','Temperature2(F)', ...
        'Output1(mV)','Output2(mV)','tau1','tau2', ...
        'K11','K12','K22','K21','Control Mode'};
    data_out(:,1) = time_out;
    data_out(:,2) = setPoint1;
    data_out(:,3) = setPoint2;
    data_out(:,4) = temperature1;
    data_out(:,5) = temperature2;
    data_out(:,6) = output1;
    data_out(:,7) = output2;
    data_out(:,8) = parameters(1:(end-1),1);
    data_out(:,9) = parameters(1:(end-1),2);
    data_out(:,10) = parameters(1:(end-1),3);
    data_out(:,11) = parameters(1:(end-1),4);
    data_out(:,12) = parameters(1:(end-1),5);
    data_out(:,13) = parameters(1:(end-1),6);
    data_out(:,14) = control;
    currentTime = TimeStamp();
    csvwrite_with_headers(['Collected Data\PID_Output_',currentTime,'.csv'],data_out,headers);
    
    % and give mean/median values values Plot parameters
    if get(handles.mhe,'Value') == get(handles.mhe,'Max')
        figure(2)
        
        subplot(2,2,1)
        plot(data_out(:,1),data_out(:,10))
        legend('K11')
        hold on
        
        subplot(2,2,2)
        plot(data_out(:,1),data_out(:,11))
        legend('K12')
        
        subplot(2,2,3)
        plot(data_out(:,1),data_out(:,12))
        legend('K22')
        
        subplot(2,2,4)
        plot(data_out(:,1),data_out(:,13))
        legend('K21')
    end
    
    %Switch Button label back
    pause(.01);
    set(handles.save_text,'Visible','on');
    set(handles.action_button,'String','Start');
    set(handles.action_button,'BackgroundColor',[0 .7 0]);
    disp('Closing Connection.');
    
    a.analogWrite(3,0)
    delete(a)
end


% --- Executes on button press in clear_button.
function clear_button_Callback(hObject, eventdata, handles)
% hObject    handle to clear_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
cla(handles.axes1);



function setpoint_Callback(hObject, eventdata, handles)
% hObject    handle to setpoint (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of setpoint as text
%        str2double(get(hObject,'String')) returns contents of setpoint as a double


% --- Executes during object creation, after setting all properties.
function setpoint_CreateFcn(hObject, eventdata, handles)
% hObject    handle to setpoint (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




function kp_Callback(hObject, eventdata, handles)
% hObject    handle to kp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kp as text
%        str2double(get(hObject,'String')) returns contents of kp as a double


% --- Executes during object creation, after setting all properties.
function kp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ki_Callback(hObject, eventdata, handles)
% hObject    handle to ki (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ki as text
%        str2double(get(hObject,'String')) returns contents of ki as a double


% --- Executes during object creation, after setting all properties.
function ki_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ki (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function kd_Callback(hObject, eventdata, handles)
% hObject    handle to kd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kd as text
%        str2double(get(hObject,'String')) returns contents of kd as a double


% --- Executes during object creation, after setting all properties.
function kd_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes when selected object is changed in mode_panel.
function mode_panel_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in mode_panel
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)
if get(handles.control_button,'Value') == get(handles.control_button,'Max')
    set(handles.setpoint1,'Enable','on','Visible','on');
    set(handles.setpoint2,'Enable','on','Visible','on');
    set(handles.kp,'Enable','on','Visible','on');
    set(handles.ki,'Enable','on','Visible','on');
    set(handles.kd,'Enable','on','Visible','on');
    set(handles.setpoint_text1,'Visible','on');
    set(handles.setpoint_text2,'Visible','on');
    set(handles.kp_text,'Visible','on');
    set(handles.ki_text,'Visible','on');
    set(handles.kd_text,'Visible','on');
    set(handles.input_message,'Visible','off');
    set(handles.voltage_text1,'Visible','on');
    set(handles.voltage_text2,'Visible','on');
    set(handles.output_text1,'Visible','on');
    set(handles.output_text2,'Visible','on');
end
if get(handles.control_button,'Value') == get(handles.control_button,'Min')
    set(handles.setpoint1,'Enable','off','Visible','off');
    set(handles.setpoint2,'Enable','off','Visible','off');
    set(handles.kp,'Enable','off','Visible','off');
    set(handles.ki,'Enable','off','Visible','off');
    set(handles.kd,'Enable','off','Visible','off');
    set(handles.setpoint_text1,'Visible','off');
    set(handles.setpoint_text2,'Visible','off');
    set(handles.kp_text,'Visible','off');
    set(handles.ki_text,'Visible','off');
    set(handles.kd_text,'Visible','off');
    set(handles.input_message,'Visible','on');
    set(handles.voltage_text1,'Visible','off');
    set(handles.voltage_text2,'Visible','off');
    set(handles.output_text1,'Visible','off');
    set(handles.output_text2,'Visible','off');
end
if get(handles.manual_button,'Value') == get(handles.control_button,'Max')
    set(handles.output_field1,'Enable','on','Visible','on');
    set(handles.output_field2,'Enable','on','Visible','on');
    set(handles.output_text1,'Visible','on');
    set(handles.output_text2,'Visible','on');
    set(handles.input_message,'Visible','off');
end
if get(handles.manual_button,'Value') == get(handles.control_button,'Min')
    set(handles.output_field1,'Enable','off','Visible','off');
    set(handles.output_field2,'Enable','off','Visible','off');
end
if get(handles.custom_button,'Value') == get(handles.control_button,'Max')
    set(handles.setpoint1,'Enable','on','Visible','on');
    set(handles.setpoint2,'Enable','on','Visible','on');
    set(handles.setpoint_text1,'Visible','on');
    set(handles.setpoint_text2,'Visible','on');
    set(handles.input_message,'Visible','off');
    set(handles.voltage_text1,'Visible','on');
    set(handles.voltage_text2,'Visible','on');
    set(handles.output_text1,'Visible','on');
    set(handles.output_text2,'Visible','on');
end
if get(handles.mhe,'Value') == get(handles.mhe,'Max')
    set(handles.recent_text,'Visible','on');
    set(handles.rk11,'Visible','on');
    set(handles.K11r,'Visible','on');
    set(handles.rk12,'Visible','on');
    set(handles.K12r,'Visible','on');
    set(handles.rk22,'Visible','on');
    set(handles.K22r,'Visible','on');
    set(handles.rk21,'Visible','on');
    set(handles.K21r,'Visible','on');
    set(handles.medians_text,'Visible','on');
    set(handles.mk11,'Visible','on');
    set(handles.K11m,'Visible','on');
    set(handles.mk12,'Visible','on');
    set(handles.K12m,'Visible','on');
    set(handles.mk22,'Visible','on');
    set(handles.K22m,'Visible','on');
    set(handles.mk21,'Visible','on');
    set(handles.K21m,'Visible','on');
end
if get(handles.mhe,'Value') == get(handles.mhe,'Min')
    set(handles.recent_text,'Visible','off');
    set(handles.rk11,'Visible','off');
    set(handles.K11r,'Visible','off');
    set(handles.rk12,'Visible','off');
    set(handles.K12r,'Visible','off');
    set(handles.rk22,'Visible','off');
    set(handles.K22r,'Visible','off');
    set(handles.rk21,'Visible','off');
    set(handles.K21r,'Visible','off');
    set(handles.medians_text,'Visible','off');
    set(handles.mk11,'Visible','off');
    set(handles.K11m,'Visible','off');
    set(handles.mk12,'Visible','off');
    set(handles.K12m,'Visible','off');
    set(handles.mk22,'Visible','off');
    set(handles.K22m,'Visible','off');
    set(handles.mk21,'Visible','off');
    set(handles.K21m,'Visible','off');
end



function output_field_Callback(hObject, eventdata, handles)
% hObject    handle to output_field (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of output_field as text
%        str2double(get(hObject,'String')) returns contents of output_field as a double
vala = str2double(get(handles.output_field1,'String'));
val2a = vala;
if vala > 255
    val2a = 255;
end
if vala < 0
    val2a = 0;
end
if val2a ~= vala
    set(handles.output_field1,'String',num2str(val2a));
end
valb = str2double(get(handles.output_field2,'String'));
val2b = valb;
if valb > 255
    val2b = 255;
end
if valb < 0
    val2b = 0;
end
if val2b ~= valb
    set(handles.output_field2,'String',num2str(val2b));
end


% --- Executes during object creation, after setting all properties.
function output_field_CreateFcn(hObject, eventdata, handles)
% hObject    handle to output_field (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function axes2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to axes2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate axes2


% --- Executes on mouse press over axes background.
function axes2_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to axes2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object deletion, before destroying properties.
function axes2_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to axes2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
