function [tau1, tau2, K11, K12, K22, K21] = mhe(T1_meas,T2_meas,out1,out2)
%, theta11, theta12, theta22, theta21 (add back in if you include dead
%time)

persistent estimator_initialized
persistent s a1
persistent webview
persistent timer

if isempty(estimator_initialized)
    s = 'http://byu.apmonitor.com';
    a1 = 'mhe';
    msg1 = init_mhe(s,a1);
    disp(msg1);
    estimator_initialized = true;
end

if isempty(timer)
    tic
    timer = toc;
    first = true;
else
    first = false;
end

t = toc;

if (t - timer < 10) && (~ first)
    tau1 = apm_tag(s,a1,'tau1.newval');
    tau2 = apm_tag(s,a1,'tau2.newval');
    K11 = apm_tag(s,a1,'K11.newval');
    K12 = apm_tag(s,a1,'K12.newval');
    K22 = apm_tag(s,a1,'K22.newval');
    K21 = apm_tag(s,a1,'K21.newval');
    return
end

tic

apm_meas(s,a1,'T1',T1_meas);
apm_meas(s,a1,'T2',T2_meas);
apm_meas(s,a1,'u1',out1);
apm_meas(s,a1,'u2',out2);

output = apm(s,a1,'solve');
disp(output)
if isempty(webview)
    apm_web(s,a1);
    webview = true;
end

if (apm_tag(s,a1,'nlc.appstatus')==1)
    tau1 = apm_tag(s,a1,'tau1.newval');
    tau2 = apm_tag(s,a1,'tau2.newval');
    K11 = apm_tag(s,a1,'K11.newval');
    K12 = apm_tag(s,a1,'K12.newval');
    K22 = apm_tag(s,a1,'K22.newval');
    K21 = apm_tag(s,a1,'K21.newval');
    %theta11 = apm_tag(s,a1,'theta11.newval');
    %theta12 = apm_tag(s,a1,'theta12.newval');
    %theta22 = apm_tag(s,a1,'theta22.newval');
    %theta21 = apm_tag(s,a1,'theta21.newval');
else
    tau1 = 144;          % Time constant for unit 1 (sec)
  % 218 for when u2 is stepped up to 200 V
    tau2 = 163;            % Time constant for unit 2 (sec)
  % 263 for when u1 is stepped up to 100 V
    K11 = 0.336;           % Gain for unit 1 with input 1 (del_T/del_V) 
    K12 = 0.160;           % Gain for unit 1 with input 2 (del_T/del_V) 
    K22 = 0.191;           % Gain for unit 2 with input 2 (del_T/del_V)
    K21 = 0.0812;          % Gain for unit 2 with input 1 (del_T/del_V)
    %theta11 = 2.1;         % Dead Time for unit 1 with input 1 (sec)
    %theta12 = 24.2;        % Dead Time for unit 1 with input 2 (sec)
    %theta22 = 8.9;         % Dead Time for unit 2 with input 2 (sec)
    %theta21 = 69.6;        % Dead Time for unit 2 with input 1 (sec)
    display('no funciono : /')
end

return
