function msg = init_mhe(s,a1)

addpath('apm');
apm(s,a1,'clear all');

% Load files
apm_load(s,a1,'model.apm');
csv_load(s,a1,'mhe.csv');

% Set global options
apm_option(s,a1,'nlc.imode',5);
apm_option(s,a1,'nlc.nodes',3);

% Declare variables
apm_info(s,a1,'FV','tau1');
apm_info(s,a1,'FV','tau2');
apm_info(s,a1,'FV','K11');
apm_info(s,a1,'FV','K12');
apm_info(s,a1,'FV','K22');
apm_info(s,a1,'FV','K21');
apm_info(s,a1,'MV','u1');
apm_info(s,a1,'MV','u2');
apm_info(s,a1,'CV','T1');
apm_info(s,a1,'CV','T2');

% Set status and limits of parameters
apm_option(s,a1,'tau1.status',0);
apm_option(s,a1,'tau1.lower',0.001);
apm_option(s,a1,'tau1.upper',10000);

apm_option(s,a1,'tau2.status',0);
apm_option(s,a1,'tau2.lower',0.001);
apm_option(s,a1,'tau2.upper',10000);

apm_option(s,a1,'K11.status',1);
apm_option(s,a1,'K11.lower',0.00001);
apm_option(s,a1,'K11.upper',10);

apm_option(s,a1,'K12.status',1);
apm_option(s,a1,'K12.lower',0.00001);
apm_option(s,a1,'K12.upper',10);

apm_option(s,a1,'K22.status',1);
apm_option(s,a1,'K22.lower',0.00001);
apm_option(s,a1,'K22.upper',10);

apm_option(s,a1,'K21.status',1);
apm_option(s,a1,'K21.lower',0.00001);
apm_option(s,a1,'K21.upper',10);

apm_option(s,a1,'u1.status',0);
apm_option(s,a1,'u2.status',0);
apm_option(s,a1,'T1.status',0);
apm_option(s,a1,'T2.status',0);

apm_option(s,a1,'T1.fstatus',1);
apm_option(s,a1,'T2.fstatus',1);

msg = 'MHE Initialized';

return