function A = mpc(T1_meas,T2_meas,desiredTemp1,desiredTemp2)
%function A = mpc(p_meas,T1_meas,T2_meas,desiredTemp1,desiredTemp2)

persistent controller_initialized
persistent s a2
persistent webview
persistent timer

% Initialize the controller
if isempty(controller_initialized)
    s = 'http://byu.apmonitor.com';
    a2 = 'mpc';
    msg2 = init_mpc(s,a2);
    disp(msg2);
    controller_initialized = true;
end

% Begin timer
if isempty(timer)
    tic
    timer = toc;
    first = true;
else
    first = false;
end

t = toc;

% Limits the solver to finding a solution every one second
if (t - timer < 1) && (~ first);
    Vin1 = apm_tag(s,a2,'vin1.newval');
    Vin2 = apm_tag(s,a2,'vin2.newval');
    A = [Vin1 Vin2];
    return
end

tic

% Set setpoints
sphi1 = desiredTemp1 + 1.0;
splo1 = desiredTemp1 - 1.0;
apm_option(s,a2,'TdegF1.sphi',sphi1);
apm_option(s,a2,'TdegF1.splo',splo1);

sphi2 = desiredTemp2 + 1.0;
splo2 = desiredTemp2 - 1.0;
apm_option(s,a2,'TdegF2.sphi',sphi2);
apm_option(s,a2,'TdegF2.splo',splo2);

% Input measured data from Arduino
apm_meas(s,a2,'TdegF1',T1_meas);
apm_meas(s,a2,'TdegF2',T2_meas);

% Input parameters from MHE
%apm_meas(s,a2,'tau1',p_meas(1));
%apm_meas(s,a2,'tau2',p_meas(2));
%apm_meas(s,a2,'K11',p_meas(3));
%apm_meas(s,a2,'K12',p_meas(4));
%apm_meas(s,a2,'K22',p_meas(5));
%apm_meas(s,a2,'K21',p_meas(6));

output = apm(s,a2,'solve');

% Check to make sure that the solver solved
if (apm_tag(s,a2,'nlc.appstatus')==1)
    Vin1 = apm_tag(s,a2,'vin1.newval');
    Vin2 = apm_tag(s,a2,'vin2.newval');
    
    if isempty(webview)
        apm_web(s,a2);
        webview = true;
    end
    
else
    disp(output)
    Vin1 = 0;
    Vin2 = 0;
end

A = [Vin1 Vin2];

return
