function msg = init_mpc(s,a2)

addpath('apm');
apm(s,a2,'clear all');

% Load files
apm_load(s,a2,'model.apm');
csv_load(s,a2,'mpc.csv');

% Set global options
apm_option(s,a2,'nlc.imode',6);
apm_option(s,a2,'nlc.nodes',3);
apm_option(s,a2,'nlc.WEB_PLOT_FREQ',1);

% Declare variables
apm_info(s,a2,'FV','tau1');
apm_info(s,a2,'FV','tau2');
apm_info(s,a2,'FV','K11');
apm_info(s,a2,'FV','K12');
apm_info(s,a2,'FV','K22');
apm_info(s,a2,'FV','K21');

apm_info(s,a2,'MV','Vin1');
apm_info(s,a2,'MV','Vin2');
apm_info(s,a2,'CV','TdegF1');
apm_info(s,a2,'CV','TdegF2');

% Set status and limits of variables
apm_option(s,a2,'tau1.fstatus',0);
apm_option(s,a2,'tau2.fstatus',0);
apm_option(s,a2,'K11.fstatus',1);
apm_option(s,a2,'K12.fstatus',1);
apm_option(s,a2,'K22.fstatus',1);
apm_option(s,a2,'K21.fstatus',1);

apm_option(s,a2,'Vin1.status',1);
apm_option(s,a2,'Vin1.lower',0);
apm_option(s,a2,'Vin1.upper',255);
%apm_option(s,a2,'Vin1.dmax',30);

apm_option(s,a2,'Vin2.status',1);
apm_option(s,a2,'Vin2.lower',0);
apm_option(s,a2,'Vin2.upper',255);
%apm_option(s,a2,'Vin2.dmax',30);

apm_option(s,a2,'TdegF1.status',1);
apm_option(s,a2,'TdegF1.fstatus',1);
apm_option(s,a2,'TdegF1.tr_init',0);

apm_option(s,a2,'TdegF2.status',1);
apm_option(s,a2,'TdegF2.fstatus',1);
apm_option(s,a2,'TdegF2.tr_init',0);

msg = 'MPC Initialized';

return