# Add path to APM libraries
from apm import *
from random import randint

# Select server
#server = 'http://xps.apmonitor.com'
server = 'http://byu.apmonitor.com'

# Application name
r = randint(0,10000)
app = 'sofc_steps_' + str(r)

# Clear previous application
apm(server,app,'clear all')

# load model variables and equations
apm_load(server,app,'sofc.apm')

# load data
csv_load(server,app,'step_response.csv')

# Set up variable classifications for data flow

# Feedforwards - measured process disturbances
apm_info(server,app,'FV','sofc.m_air_total')
apm_info(server,app,'FV','sofc.tgcrbc')
# Manipulated variables (for controller design)
apm_info(server,app,'MV','sofc.Vcell')
apm_info(server,app,'MV','ejector.pPin')
apm_info(server,app,'MV','ejector.TPin')
apm_info(server,app,'MV','sofc.ncells')
apm_info(server,app,'MV','sofc.pcomb')
apm_info(server,app,'MV','sofc.m_fuel_total')
# State variables (for display only)
apm_info(server,app,'SV','sofc.tga[1]')
apm_info(server,app,'SV','sofc.powertot')
# Controlled variables (for controller design)
apm_info(server,app,'CV','sofc.tcellmin')
apm_info(server,app,'CV','sofc.dtradmax')
apm_info(server,app,'CV','sofc.uf')
apm_info(server,app,'CV','sofc.power')

# imode = 7, switch to sequential simulation
apm_option(server,app,'nlc.imode',7)
# nodes = 2, internal nodes in the collocation structure (2-6)
apm_option(server,app,'nlc.nodes',2)
# time to display on trends (1=sec, 2=min, 3=hr, etc)
apm_option(server,app,'nlc.ctrl_units',1)
# maximum time
apm_option(server,app,'nlc.max_time',60)
# maximum iterations
apm_option(server,app,'nlc.max_iter',50)

# Run APMonitor
output = apm(server,app,'solve')
print(output)

# Retrieve solution (creates solution.csv locally)
z = apm_sol(server,app)

t = z['time']
vcell = z['sofc.vcell']
ppin = z['ejector.ppin']
tpin = z['ejector.tpin']
m_fuel_total = z['sofc.m_fuel_total']
tcellmin = z['sofc.tcellmin']
power = z['sofc.power']

# plot results in python
import matplotlib.pyplot as plt

plt.figure(1)
plt.subplot(6,1,1)
plt.plot(t,vcell,'k-')
plt.ylabel('Vcell')
plt.legend('Vcell')

plt.subplot(6,1,2)
plt.plot(t,ppin,'k-')
plt.ylabel('pPin')
plt.legend('pPin')

plt.subplot(6,1,3)
plt.plot(t,tpin,'k-')
plt.ylabel('TPin')
plt.legend('TPin')

plt.subplot(6,1,4)
plt.plot(t,m_fuel_total,'k-')
plt.ylabel('m_fuel_total')
plt.legend('Total Fuel')

plt.subplot(6,1,5)
plt.plot(t,tcellmin,'b-')
plt.ylabel('tcell_{min} (K)')
plt.legend('Min Cell Temp')

plt.subplot(6,1,6)
plt.plot(t,power,'b-')
plt.ylabel('power (W)')
plt.xlabel('time (sec)')
plt.legend('Power')

plt.show()
