% Add path to APM libraries
addpath('apm');

% Clear MATLAB
clear all
close all

% Select server
%server = 'http://xps.apmonitor.com';
server = 'http://byu.apmonitor.com';

% Application
app = ['sofc_steps_' int2str(10000*rand())];

% Clear previous application
apm(server,app,'clear all');

% load model variables and equations
apm_load(server,app,'sofc.apm');

% load data
csv_load(server,app,'step_response.csv');

% Set up variable classifications for data flow

% Feedforwards - measured process disturbances
apm_info(server,app,'FV','sofc.m_air_total');
apm_info(server,app,'FV','sofc.tgcrbc');
% Manipulated variables (for controller design)
apm_info(server,app,'MV','sofc.Vcell');
apm_info(server,app,'MV','ejector.pPin');
apm_info(server,app,'MV','ejector.TPin');
apm_info(server,app,'MV','sofc.ncells');
apm_info(server,app,'MV','sofc.pcomb');
apm_info(server,app,'MV','sofc.m_fuel_total');
% State variables (for display only)
apm_info(server,app,'SV','sofc.tga[1]');
apm_info(server,app,'SV','sofc.powertot');
% Controlled variables (for controller design)
apm_info(server,app,'CV','sofc.tcellmin');
apm_info(server,app,'CV','sofc.dtradmax');
apm_info(server,app,'CV','sofc.uf');
apm_info(server,app,'CV','sofc.power');

% imode = 7, switch to sequential simulation
apm_option(server,app,'nlc.imode',7);
% nodes = 2, internal nodes in the collocation structure (2-6)
apm_option(server,app,'nlc.nodes',2);
% time to display on trends (1=sec, 2=min, 3=hr, etc)
apm_option(server,app,'nlc.ctrl_units',1);
% maximum time
apm_option(server,app,'nlc.max_time',60);
% maximum iterations
apm_option(server,app,'nlc.max_iter',50);

% Run APMonitor
apm(server,app,'solve')
  
% Retrieve solution (creates solution.csv locally)
y = apm_sol(server,app);
z = y.x;

t = z.time;
vcell = z.sofcvcell;
ppin = z.ejectorppin;
tpin = z.ejectortpin;
m_fuel_total = z.sofcm_fuel_total;
tcellmin = z.sofctcellmin;
power = z.sofcpower;

% plot results in matlab
figure(1)
subplot(6,1,1);
plot(t,vcell,'k-');
ylabel('Vcell');
legend('Vcell');

subplot(6,1,2);
plot(t,ppin,'k-');
ylabel('pPin');
legend('pPin');

subplot(6,1,3);
plot(t,tpin,'k-');
ylabel('TPin');
legend('TPin');

subplot(6,1,4);
plot(t,m_fuel_total,'k-');
ylabel('m fuel total');
legend('Total Fuel');

subplot(6,1,5);
plot(t,tcellmin,'b-');
ylabel('tcell_{min} (K)');
legend('Min Cell Temp');

subplot(6,1,6);
plot(t,power,'b-');
ylabel('power (W)');
xlabel('time (sec)');
legend('Power');

% open a web interface
%apm_web(server,app);