% Add path to APM libraries
addpath('apm');

% Clear MATLAB
clear all
close all

% Select server (uncomment appropriate line)
%server = 'http://xps.apmonitor.com';
%server = 'http://localhost';
server = 'http://byu.apmonitor.com';

% Application
app = ['sofc_control_' int2str(10000*rand())];

% Clear previous application
apm(server,app,'clear all');

% load model variables and equations
apm_load(server,app,'sofc.apm');

% load data
csv_load(server,app,'control.csv');

% Set up variable classifications for data flow

% Feedforwards - measured process disturbances
apm_info(server,app,'FV','sofc.m_air_total');
apm_info(server,app,'FV','sofc.tgcrbc');
% Manipulated variables (for controller design)
apm_info(server,app,'MV','sofc.Vcell');
apm_info(server,app,'MV','ejector.pPin');
apm_info(server,app,'MV','ejector.TPin');
apm_info(server,app,'MV','sofc.ncells');
apm_info(server,app,'MV','sofc.pcomb');
apm_info(server,app,'MV','sofc.m_fuel_total');
% State variables (for display only)
apm_info(server,app,'SV','sofc.tga[1]');
apm_info(server,app,'SV','sofc.powertot');
% Controlled variables (for controller design)
apm_info(server,app,'CV','sofc.tcellmin');
apm_info(server,app,'CV','sofc.dtradmax');
apm_info(server,app,'CV','sofc.uf');
apm_info(server,app,'CV','sofc.power');

% imode = 6, switch to control
apm_option(server,app,'nlc.imode',6);
% nodes = 2, internal nodes in the collocation structure (2-6)
apm_option(server,app,'nlc.nodes',2);
% time to display on trends (1=sec, 2=min, 3=hr, etc)
apm_option(server,app,'nlc.ctrl_units',1);
% maximum time
apm_option(server,app,'nlc.max_time',60);
% maximum iterations
apm_option(server,app,'nlc.max_iter',50);
% sensitivity calculation
apm_option(server,app,'nlc.sensitivity',1);

% Coldstart controller
apm_option(server,app,'nlc.reqctrlmode',1);
% Run APMonitor
apm(server,app,'solve')

% Turn on controller
apm_option(server,app,'nlc.reqctrlmode',3);

% MV controller tuning
apm_option(server,app,'sofc.Vcell.status',1);
apm_option(server,app,'sofc.Vcell.fstatus',0);
apm_option(server,app,'sofc.Vcell.dmax',0.01);
apm_option(server,app,'sofc.Vcell.upper',0.7);
apm_option(server,app,'sofc.Vcell.lower',0.53);
apm_option(server,app,'sofc.Vcell.mv_step_hor',1);

apm_option(server,app,'ejector.TPin.status',1);
apm_option(server,app,'ejector.TPin.fstatus',0);
apm_option(server,app,'ejector.TPin.dmax',1);
apm_option(server,app,'ejector.TPin.upper',400);
apm_option(server,app,'ejector.TPin.lower',350);
apm_option(server,app,'ejector.TPin.mv_step_hor',2);

apm_option(server,app,'ejector.PPin.status',1);
apm_option(server,app,'ejector.PPin.fstatus',0);
apm_option(server,app,'ejector.PPin.dmax',1e4);
apm_option(server,app,'ejector.PPin.upper',9e5);
apm_option(server,app,'ejector.PPin.lower',8e5);
apm_option(server,app,'ejector.PPin.mv_step_hor',2);

% CV controller tuning
apm_option(server,app,'sofc.power.sphi',160.0);
apm_option(server,app,'sofc.power.splo',160.0);
apm_option(server,app,'sofc.power.wsphi',100);
apm_option(server,app,'sofc.power.wsplo',100);
apm_option(server,app,'sofc.power.status',1);
apm_option(server,app,'sofc.power.tau',5);
apm_option(server,app,'sofc.power.tr_init',2);
apm_option(server,app,'sofc.power.tr_open',1);

apm_option(server,app,'sofc.tcellmin.sphi',1020);
apm_option(server,app,'sofc.tcellmin.splo',1000);
apm_option(server,app,'sofc.tcellmin.wsphi',0);
apm_option(server,app,'sofc.tcellmin.wsplo',10000);
apm_option(server,app,'sofc.tcellmin.status',1);
apm_option(server,app,'sofc.tcellmin.tr_init',0);


% Run APMonitor
for i = 1:5
  apm(server,app,'solve')
  % open a web interface
  if i==1
     apm_web(server,app);
  end
end
  
% Retrieve solution (creates solution.csv locally)
y = apm_sol(server,app);
z = y.x;

t = z.time;
vcell = z.sofcvcell;
ppin = z.ejectorppin;
tpin = z.ejectortpin;
m_fuel_total = z.sofcm_fuel_total;
tcellmin = z.sofctcellmin;
power = z.sofcpower;

% plot results in matlab
figure(1)
subplot(6,1,1);
plot(t,vcell,'k-');
ylabel('Vcell');
legend('Vcell');

subplot(6,1,2);
plot(t,ppin,'k-');
ylabel('pPin');
legend('pPin');

subplot(6,1,3);
plot(t,tpin,'k-');
ylabel('TPin');
legend('TPin');

subplot(6,1,4);
plot(t,m_fuel_total,'k-');
ylabel('m fuel total');
legend('Total Fuel');

subplot(6,1,5);
plot(t,tcellmin,'b-');
ylabel('tcell_{min} (K)');
legend('Min Cell Temp');

subplot(6,1,6);
plot(t,power,'b-');
ylabel('power (W)');
xlabel('time (sec)');
legend('Power');
