function y = ferrari(p)

persistent s a icount

if (isempty(icount)),
    % -------------------------------------------
    % Setting up APMonitor
    % For any tutorials see 
    % http://apmonitor.com/wiki/index.php/Main/MATLAB
    % -------------------------------------------
    
    % Add path to APM libraries
    addpath('apm');
    
    % Select server and application name
    %s = 'http://byu.apmonitor.com';
    s = 'http://localhost';
    a = 'ferrari';
    
    % Clear previous application
    apm(s,a,'clear all');
    
    % load model variables and equations
    apm_load(s,a,'ferrari.apm');
    
    % load data
    csv_load(s,a,'ferrari1.csv');
    
    %  APM Variable Classification
    apm_info(s,a,'FV','p');
    apm_info(s,a,'SV','v');
    
    % Options
    apm_option(s,a,'nlc.imode',4);
    apm_option(s,a,'nlc.nodes',3);
    
    % Initialize counter
    icount = 0;
end

icount = icount + 1;

% Input pedal measurement
apm_meas(s,a,'p',p);

% Solve
output = apm(s,a,'solve');

% Output velocity
y(1) = apm_tag(s,a,'v.model');

disp(['Count: ' int2str(icount) ', Pedal: ' int2str(p) ', Velocity: ' num2str(y)])

end
