clear all; close all; clc

%% problem statement
x0 = 3.0;  % initial condition
tf = 10.0; % final time
tau = 5.0; % model parameter (time constant)

%% analytic solution
time = linspace(0,tf);
x = x0*exp(-time/tau);

%% numeric solutions
% 2nd order polynomial (3 points)
t2 = tf * [0 0.5 1.0];
N2 = [0.75 -0.25; ...
    1.0 0.0];
M2 = inv(tf * N2);
% Solve linear system of equations by matrix manipulation
x2 = [x0; inv(tau * M2 + eye(2))*(tau*M2)*ones(2,1)*x0]';

% 3rd order polynomial (4 points)
t3 = tf * [0 1/2-sqrt(5)/10 1/2+sqrt(5)/10 1.0];
N3 = [0.436 -0.281 0.121; ...
    0.614 0.064 0.046; ...
    0.603 0.230 0.167];
M3 = inv(tf * N3);
% Solve linear system of equations by matrix manipulation
x3 = [x0; inv(tau * M3 + eye(3))*(tau*M3)*ones(3,1)*x0]';

% 4th order polynomial (5 points)
t4 = tf * [0 1/2-sqrt(21)/14 1/2 1/2+sqrt(21)/14 1];
N4 = [0.278 -0.202 0.169 -0.071; ...
    0.398 0.069 0.064 -0.031; ...
    0.387 0.234 0.278 -0.071;
    0.389 0.222 0.389 0.000];
M4 = inv(tf * N4);
% Solve linear system of equations by matrix manipulation
x4 = [x0; inv(tau * M4 + eye(4))*(tau*M4)*ones(4,1)*x0]';

% compare results
figure(1)
subplot(2,1,1)
plot(time,x,'r-','LineWidth',3)
hold on
plot(t2,x2,'b--.','LineWidth',2,'MarkerSize',20)
plot(t3,x3,'k:.','LineWidth',2,'MarkerSize',20)
plot(t4,x4,'g.-','LineWidth',2,'MarkerSize',20)
xlabel('Time')
ylabel('Value')
legend('Exact','3 Points','4 Points','5 Points')
text(2,0.5,'\tau dx/dt = -x')

subplot(2,1,2)
% exact solutions at collocation points
y2 = x0*exp(-t2/tau);
y3 = x0*exp(-t3/tau);
y4 = x0*exp(-t4/tau);
plot(t2,x2-y2,'b--.','LineWidth',2,'MarkerSize',20)
hold on
plot(t3,x3-y3,'k:.','LineWidth',2,'MarkerSize',20)
plot(t4,x4-y4,'g.-','LineWidth',2,'MarkerSize',20)
xlabel('Time')
ylabel('Error')
legend('3 Points','4 Points','5 Points')
