# Add APM libraries to path for session
from apm import *

# Select server
s = 'http://byu.apmonitor.com';

# Application
a = 'multiobjective';

# Clear previous application
apm(s,a,'clear all');

# load model variables and equations
print('Loading APM model file')
apm_load(s,a,'demo.apm');

# load data
csv_load(s,a,'demo.csv');

#Define Manipulated Variables
apm_info(s,a,'MV','u');
 
#Define Controled Variables
apm_info(s,a,'CV','y');
apm_info(s,a,'CV','z');
apm_info(s,a,'CV','s');
  
#Dynamic NMPC Controller mode
apm_option(s,a,'nlc.imode',6);
    
# turn on controller for first cycle
# 1=simulate, 2=predict, 3=control
apm_option(s,a,'nlc.reqctrlmode',3);
 
apm_option(s,a,'nlc.max_iter',100);
 
# set some additional options
apm_option(s,a,'nlc.cv_type',1);
apm_option(s,a,'nlc.mv_type',0);
apm_option(s,a,'nlc.solver',1);
 
# some additional options
#apm_option(s,a,'nlc.coldstart',1);
apm_option(s,a,'nlc.mv_step_hor',5);
apm_option(s,a,'nlc.hist_hor',200);
 
##################################################################
# Environmental Constraint
##################################################################
#setup CV
# tau is the speed of the CV response, 0=step, 1 = 63.2# of the way to
#   the new setpoint in 1 sec, only if tr_init is 1 or 2.
# with tr_init=0, it is just a pure dead-band
# specifying the speed to get to the set point
# get to 63.2# of sp withing tau seconds
apm_option(s,a,'y.tau',5);
apm_option(s,a,'y.status',1);
apm_option(s,a,'y.tr_init',2);
#  sp = 5;
#  apm_option(s,a,'z['sp',sp);
apm_option(s,a,'y.sphi',5);
apm_option(s,a,'y.splo',4);
# fstatus = 0 (don't use measurement) fstatus = 1 (use measurement)
apm_option(s,a,'y.fstatus',0);
apm_option(s,a,'y.wsphi',100);
apm_option(s,a,'y.wsplo',100);
 
##################################################################
# Operational Constraint
##################################################################
apm_option(s,a,'z.tau',4);
apm_option(s,a,'z.status',1);
apm_option(s,a,'z.tr_init',2);
#  sp = 5;
#  apm_option(s,a,'z['sp',sp);
apm_option(s,a,'z.sphi',7);
apm_option(s,a,'z.splo',6);
# fstatus = 0 (don't use measurement) fstatus = 1 (use measurement)
apm_option(s,a,'z.fstatus',0);
apm_option(s,a,'z.wsphi',50);
apm_option(s,a,'z.wsplo',50);
 
##################################################################
# Safety Constrains
##################################################################
apm_option(s,a,'s.tau',10);
apm_option(s,a,'s.status',1);
apm_option(s,a,'s.tr_init',2);
apm_option(s,a,'s.tr_open',3);
#  sp = 5;
#  apm_option(s,a,'z['sp',sp);
apm_option(s,a,'s.sphi',11);
apm_option(s,a,'s.splo',10);
# fstatus = 0 (don't use measurement) fstatus = 1 (use measurement)
apm_option(s,a,'s.fstatus',0);
apm_option(s,a,'s.wsphi',200);
apm_option(s,a,'s.wsplo',200);
##################################################################
 
#setup MV (x)
apm_option(s,a,'u.status',1);
apm_option(s,a,'u.fstatus',0);
apm_option(s,a,'u.dmax',1e5); # rate of change limits
#     apm_option(s,a,'q_p.dcost',0);# adding cost for change
apm_option(s,a,'u.dcost',0);# adding cost for change
apm_option(s,a,'u.lower',0); # lower limit
apm_option(s,a,'u.upper',1000); # upper limit
apm_option(s,a,'u.cost',0);
    
# time units (1=sec, 2=min, 3=hr, 4=day, 5=yr)
apm_option(s,a,'nlc.ctrl_units',1);
 
# 2 points per time interval : 1 second
apm_option(s,a,'nlc.nodes',2);
    
# # coldstart = 0 is no coldstart
# # coldstart = 1 is delete all restart files and use APM values
# # coldstart = 2 is delete all restart files and perform a problem
# #               decomposition that breaks the model into simpler pieces
apm_option(s,a,'nlc.coldstart',0);
 
# read csv file
apm_option(s,a,'nlc.csv_read',1);   

# solve and display output
solver_output = apm(s,a,'solve');
#solver_output=apm_solve(a);
print(solver_output)

# check solution status
status = apm_tag(s,a,'nlc.appstatus');

# get cpu time
cpu_time = apm_tag(s,a,'nlc.solvetime');

print(['Application Status: ' + str(status) + ' CPU Time: ' + str(cpu_time)]);

apm_web(s,a);

z = apm_sol(s,a);

import matplotlib.pyplot as plt

plt.figure(1)

plt.plot(z['time'],z['s.tr_hi'],'r-.',linewidth=3)
plt.plot(z['time'],z['y.tr_hi'],'b:',linewidth=2)
plt.plot(z['time'],z['z.tr_hi'],'k--',linewidth=1)
plt.plot(z['time'],z['z'],'k-',linewidth=5)
plt.legend(['Priority 1: Safety Constraint','Priority 2: Environmental Constraint','Priority 3: Economic Constraint','Response'],loc=4)
plt.plot(z['time'],z['z.tr_lo'],'k--',linewidth=1)
plt.plot(z['time'],z['y.tr_lo'],'b:',linewidth=2)
plt.plot(z['time'],z['s.tr_lo'],'r-.',linewidth=3)
plt.xlabel('Time (min)')
plt.ylabel('Pressure (bar)')
plt.show()
