# download package apm.py from APMonitor.com
from apm import *
# define server and application name
s = 'http://byu.apmonitor.com'
a = 'tune'
# clear any prior application with that name
apm(s,a,'clear all')
# load model and data file
apm_load(s,a,'multi_obj.apm')
csv_load(s,a,'data.csv')
# dynamic optimization
apm_option(s,a,'nlc.imode',6)
apm_option(s,a,'nlc.nodes',3)
# manipulated variable (u)
apm_info(s,a,'MV','u')
apm_option(s,a,'u.dcost',0.1)
apm_option(s,a,'u.dmax',2)
apm_option(s,a,'u.status',1)
apm_option(s,a,'u.fstatus',0)
apm_option(s,a,'u.upper',10)
apm_option(s,a,'u.lower',0)
# controlled variable (x)
apm_info(s,a,'CV','x')
apm_option(s,a,'x.status',1)
apm_option(s,a,'x.fstatus',0)
apm_option(s,a,'x.sphi',10)
apm_option(s,a,'x.splo',9)
apm_option(s,a,'x.tau',2)
apm_option(s,a,'x.tr_init',2)
apm_option(s,a,'x.tr_open',5)
apm_option(s,a,'x.wsphi',100)
apm_option(s,a,'x.wsplo',100)
apm_info(s,a,'CV','y')
apm_option(s,a,'y.status',1)
apm_option(s,a,'y.fstatus',0)
apm_option(s,a,'y.sphi',7)
apm_option(s,a,'y.splo',2)
apm_option(s,a,'y.tau',0)
apm_option(s,a,'y.tr_init',0)
apm_option(s,a,'y.tr_open',1)
apm_option(s,a,'y.wsphi',200)
apm_option(s,a,'y.wsplo',50)

# solve and retrieve solution
output = apm(s,a,'solve')
print (output)
z = apm_sol(s,a)

# open web-viewer
apm_web(s,a)

# plot solution
import matplotlib.pyplot as plt
plt.figure(1)
plt.subplot(211)
plt.plot(z['time'],z['u'],'k-',linewidth=2)
plt.legend('u')
plt.ylabel('MV')

plt.subplot(212)
plt.plot(z['time'],z['x'],'b-',linewidth=2)
plt.plot(z['time'],z['x.tr_hi'],'b--',linewidth=1)
plt.plot(z['time'],z['x.tr_lo'],'b--',linewidth=1)
plt.plot(z['time'],z['y'],'r-',linewidth=2)
plt.plot(z['time'],z['y.tr_hi'],'r--',linewidth=1)
plt.plot(z['time'],z['y.tr_lo'],'r--',linewidth=1)

plt.show()
