% clear variables, close plots, and clear screen
clear all; close all; clc
% download toolbox folder 'apm' from APMonitor.com
addpath('apm')
% define server and application name
s = 'http://byu.apmonitor.com';
a = 'tune';
% clear any prior application with that name
apm(s,a,'clear all');
% load model and data file
apm_load(s,a,'multi_obj.apm');
csv_load(s,a,'data.csv');
% dynamic optimization
apm_option(s,a,'nlc.imode',6);
apm_option(s,a,'nlc.nodes',3);
% manipulated variable (u)
apm_info(s,a,'MV','u');
apm_option(s,a,'u.dcost',0.1);
apm_option(s,a,'u.dmax',2);
apm_option(s,a,'u.status',1);
apm_option(s,a,'u.fstatus',0);
apm_option(s,a,'u.upper',10);
apm_option(s,a,'u.lower',0);
% controlled variable (x)
apm_info(s,a,'CV','x');
apm_option(s,a,'x.status',1);
apm_option(s,a,'x.fstatus',0);
apm_option(s,a,'x.sphi',10);
apm_option(s,a,'x.splo',9);
apm_option(s,a,'x.tau',2);
apm_option(s,a,'x.tr_init',2);
apm_option(s,a,'x.tr_open',5);
apm_option(s,a,'x.wsphi',100);
apm_option(s,a,'x.wsplo',100);
apm_info(s,a,'CV','y');
apm_option(s,a,'y.status',1);
apm_option(s,a,'y.fstatus',0);
apm_option(s,a,'y.sphi',7);
apm_option(s,a,'y.splo',2);
apm_option(s,a,'y.tau',0);
apm_option(s,a,'y.tr_init',0);
apm_option(s,a,'y.tr_open',1);
apm_option(s,a,'y.wsphi',200);
apm_option(s,a,'y.wsplo',50);

% solve and retrieve solution
output = apm(s,a,'solve');
disp(output)
sol = apm_sol(s,a);
z = sol.x;

% open web-viewer
apm_web(s,a)

% plot solution
figure(1)
subplot(2,1,1)
plot(z.time,z.u,'k-','LineWidth',2)
legend('u')
ylabel('MV')

subplot(2,1,2)
plot(z.time,z.x,'b-','LineWidth',2)
hold on
plot(z.time,z.xtr_hi,'b--','LineWidth',1)
plot(z.time,z.xtr_lo,'b--','LineWidth',1)
plot(z.time,z.y,'r-','LineWidth',2)
plot(z.time,z.ytr_hi,'r--','LineWidth',1)
plot(z.time,z.ytr_lo,'r--','LineWidth',1)

