# specify server and application name
s = 'http://byu.apmonitor.com'
a = 'motion'

from apm import *
apm(s,a,'clear all')
apm_load(s,a,'motion.apm')
csv_load(s,a,'motion.csv')

apm_option(s,a,'nlc.nodes',3)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'nlc.imode',5)
apm_option(s,a,'nlc.mv_type',1)
apm_option(s,a,'nlc.ev_type',1)

apm_info(s,a,'MV','u')
apm_option(s,a,'u.status',1)
#apm_option(s,a,'u.lower',-1000)
#apm_option(s,a,'u.upper',1000)
apm_option(s,a,'u.dcost',1e-5)

output = apm(s,a,'solve')
print (output)
y = apm_sol(s,a)

print ('Optimal Solution: ' + str(apm_tag(s,a,'nlc.objfcnval')))

import matplotlib.pyplot as plt
plt.figure(1)

plt.subplot(3,1,1)
plt.plot(y['time'],y['x1'],'b-',linewidth=3)
plt.plot(y['time'],y['y1'],'r--',linewidth=3)
plt.legend(['x1 (Position Predicted)','x1 (Position Measured)'])
plt.ylabel('Pos ($m$)')

plt.subplot(3,1,2)
plt.plot(y['time'],y['x2'],'g:',linewidth=2)
plt.legend(['x2 (Velocity)'])
plt.ylabel('Vel ($m/s$)')

plt.subplot(3,1,3)
plt.plot(y['time'],y['u'],'k.-',linewidth=2)
plt.legend(['u (Acceleration)'])
plt.ylabel('Accel ($m/s^2$)')
plt.xlabel('Time')
plt.show()
