clear all; close all; clc

s = 'http://byu.apmonitor.com';
a = 'motion';

addpath('apm')
apm(s,a,'clear all');
apm_load(s,a,'motion.apm');
csv_load(s,a,'motion.csv');

apm_option(s,a,'nlc.nodes',3);
apm_option(s,a,'nlc.solver',1);
apm_option(s,a,'nlc.imode',5);
apm_option(s,a,'nlc.mv_type',1);

apm_info(s,a,'MV','u');
apm_option(s,a,'u.status',1);
apm_option(s,a,'u.dcost',1e-5);

output = apm(s,a,'solve');
disp(output)
y = apm_sol(s,a);
z = y.x;

disp(['Optimal Solution: ' num2str(apm_tag(s,a,'nlc.objfcnval'))])

figure(1)

subplot(3,1,1)
plot(z.time,z.x1,'b-','LineWidth',3)
hold on
plot(z.time,z.y1,'r--','LineWidth',3)
legend('x1 (Position Predicted)','x1 (Position Measured)')
ylabel('Pos (m)')

subplot(3,1,2)
plot(z.time,z.x2,'g:','LineWidth',2)
legend('x2 (Velocity)')
ylabel('Vel (m/s)')

subplot(3,1,3)
plot(z.time,z.u,'k.-','LineWidth',2)
legend('u (Acceleration)')
ylabel('Accel (m/s^2)')
xlabel('Time')
