% Add path to APM libraries
addpath('../apm');

% Clear MATLAB
clear all
close all

% Select server
s = 'http://byu.apmonitor.com';
% Application
a = 'boat';

% Clear previous application
apm(s,a,'clear all');

% load model variables and equations
apm_load(s,a,'boat.apm');
% load data
csv_load(s,a,'boat.csv');

apm_option(s,a,'nlc.imode',6);
apm_option(s,a,'nlc.reqctrlmode',3);
apm_option(s,a,'nlc.nodes',3);
apm_option(s,a,'nlc.CTRL_UNITS',1);
apm_option(s,a,'nlc.time_shift',0);
apm_option(s,a,'nlc.solver',3);
%apm(s,a,'solve')

apm_info(s,a,'MV','rpm');
apm_option(s,a,'rpm.status',1);
apm_option(s,a,'rpm.dcost',0.01);
apm_option(s,a,'rpm.lower',0);
apm_option(s,a,'rpm.upper',5000);

apm_info(s,a,'CV','v');
apm_option(s,a,'v.status',1);
apm_option(s,a,'v.sphi',10.1);
apm_option(s,a,'v.splo',9.9);
apm_option(s,a,'v.tau',3);

apm_info(s,a,'CV','a');
apm_option(s,a,'a.status',1);
apm_option(s,a,'a.sphi',1.0);
apm_option(s,a,'a.splo',0.0);
apm_option(s,a,'a.tr_init',0.0);
apm_option(s,a,'a.wsphi',1000);

% solve here for steady state initialization
apm(s,a,'solve')

% open web viewer
apm_web(s,a);

% retrieve solution
y = apm_sol(s,a);
z = y.x;


figure(1)
subplot(3,1,1)
plot(z.time,z.rpm,'b-','LineWidth',2)
legend('Propeller')
ylabel('RPM')
axis tight

subplot(3,1,2)
plot(z.time,z.v,'r-','LineWidth',2)
hold on
plot(z.time,z.vtr_lo,'k:','LineWidth',2)
plot(z.time,z.vtr_hi,'k:','LineWidth',2)
legend('Boat','Lower Target','Upper Target')
ylabel('Velocity')
axis tight

subplot(3,1,3)
plot(z.time,z.a,'k-','LineWidth',2)
ylabel('Acceleration')
xlabel('Time (sec)')
axis tight
