% Clear MATLAB
clear all
close all

% Add path to APM libraries
addpath('../apm');

s = 'http://byu.apmonitor.com';
a = 'boat_estimate';

apm(s,a,'clear all');
apm_load(s,a,'boat.apm');
csv_load(s,a,'boat.csv');

apm_option(s,a,'nlc.imode',5);
apm_option(s,a,'nlc.ev_type',1);
apm_option(s,a,'nlc.time_shift',0);
apm_option(s,a,'nlc.solver',1);
apm_option(s,a,'nlc.sensitivity',1);

apm_info(s,a,'FV','mp');
apm_info(s,a,'MV','rpm');
apm_info(s,a,'CV','x');

apm_option(s,a,'x.fstatus',1);
apm_option(s,a,'x.wmeas',10);
apm_option(s,a,'x.wmodel',0);
apm_option(s,a,'mp.status',1);
apm_option(s,a,'mp.dcost',0);
apm_option(s,a,'mp.lower',0);
apm_option(s,a,'mp.upper',2000);

apm(s,a,'solve')

apm_web(s,a)
y1 = apm_sol(s,a);
z1 = y1.x;
best_obj = apm_tag(s,a,'nlc.objfcnval');
best_mp = apm_tag(s,a,'mp.newval');

% objective function sensitivity plot
apm_option(s,a,'mp.fstatus',1);
apm_option(s,a,'mp.status',0);

mp = linspace(200,1000,30);
for i = 1:size(mp,2)
    apm_meas(s,a,'mp',mp(i));
    output = apm(s,a,'solve')
    if (apm_tag(s,a,'nlc.appstatus')==1)
       obj(i) = apm_tag(s,a,'nlc.objfcnval');
    else
       obj(i) = nan;
    end
    
end

%% actual response
a = 'boat_estimate';

apm(s,a,'clear all');
apm_load(s,a,'boat.apm');
csv_load(s,a,'boat.csv');

apm_option(s,a,'nlc.imode',5);
apm_option(s,a,'nlc.ev_type',2);
apm_option(s,a,'nlc.time_shift',0);

apm_info(s,a,'FV','mp');
apm_info(s,a,'CV','x');
apm_info(s,a,'mp.fstatus',1);
apm_meas(s,a,'mp',260);
apm(s,a,'solve');

y2 = apm_sol(s,a);
z2 = y2.x;

disp(['Estimated passenger weight: ' num2str(z1.mp(1))])

data = [0.00	0.00	0.00
1.00	4007.30	0.00
2.00	4076.12	3.96
3.00	4032.04	9.59
4.00	5018.40	8.84
5.00	5033.08	25.65
6.00	5085.69	33.06
7.00	2084.71	38.92
8.00	2002.84	51.49
9.00	2082.02	64.40
10.00	2091.07	78.46
11.00	2074.44	88.33
12.00	2002.35	89.96
13.00	2013.06	107.71
14.00	0.00	117.54
15.00	0.00	121.15
16.00	0.00	131.14
17.00	0.00	130.36
18.00	0.00	138.19
19.00	0.00	147.58
20.00	0.00	150.32
21.00	0.00	155.60
22.00	0.00	155.86
23.00	0.00	152.69
24.00	0.00	163.63
25.00	0.00	167.09
26.00	0.00	166.98
27.00	0.00	170.07
28.00	0.00	172.09
29.00	0.00	170.63
30.00	0.00	175.21];

figure(1)
subplot(3,1,1)
plot(z1.time,z1.x,'b-','LineWidth',2)
hold on
plot(z1.time,data(:,3),'kx','MarkerSize',5)
plot(z2.time,z2.x,'g:','LineWidth',2)
legend('Predicted','Measured','Actual')
ylabel('Position (x)')

subplot(3,1,2)
plot(z1.time,z1.v,'b-','LineWidth',2)
hold on
plot(z2.time,z2.v,'g:','LineWidth',2)
legend('Predicted','Actual')
ylabel('Velocity (v)')

subplot(3,1,3)
plot(z1.time,z1.rpm,'r.','LineWidth',2)
hold on
plot(z2.time,z2.rpm,'g:','LineWidth',2)
legend('Predicted','Actual')
ylabel('Propeller')
legend('RPM')
xlabel('Time (sec)')

figure(2)
plot(mp,obj,'r-','LineWidth',2)
ylabel('Objective')
xlabel('Mass of Passengers (kg)')