% Clear MATLAB
clear all
close all

% Add path to APM libraries
addpath('../apm');

% simulate boat, no passengers
y1 = apm_solve('boat',7);
z1 = y1.x;

for i = 3:size(z1.x,1)
   x_meas(i) = z1.x(i) + (rand()-0.5)*10;
end

export = [z1.time z1.rpm x_meas'];
save -ascii 'export.txt' export

figure(1)
subplot(3,1,1)
plot(z1.time,z1.x,'b-','LineWidth',2)
hold on
plot(z1.time,x_meas,'kx','MarkerSize',10)
legend('No passengers','With passengers (260 kg)')
ylabel('Position (x)')

subplot(3,1,2)
plot(z1.time,z1.v,'b-','LineWidth',2)
ylabel('Velocity (v)')

subplot(3,1,3)
plot(z1.time,z1.a,'b-','LineWidth',2)
ylabel('Acceleration (a)')
xlabel('Time (sec)')
