% Clear MATLAB
clear all
close all

% Add path to APM libraries
addpath('../apm');

% simulate boat, no passengers
y1 = apm_solve('boat1',7);
z1 = y1.x;

% simulate boat, with passengers
y2 = apm_solve('boat2',7);
z2 = y2.x;

% display solution
disp(['Time: ' num2str(z1.time(7))])
disp(['Velocity (no passengers): ' num2str(z1.v(7))])
disp(['Velocity (400 kg passenger weight): ' num2str(z2.v(7))])

figure(1)
subplot(3,1,1)
plot(z1.time,z1.x,'b-','LineWidth',2)
hold on
plot(z2.time,z2.x,'r--','LineWidth',2)
legend('No passengers','With passengers (400 kg)')
ylabel('Position (x)')

subplot(3,1,2)
plot(z1.time,z1.v,'b-','LineWidth',2)
hold on
plot(z2.time,z2.v,'r--','LineWidth',2)
ylabel('Velocity (v)')

subplot(3,1,3)
plot(z1.time,z1.a,'b-','LineWidth',2)
hold on
plot(z2.time,z2.a,'r--','LineWidth',2)
ylabel('Acceleration (a)')
xlabel('Time (sec)')
