clear all; close all; clc

% Method #1 with APMonitor
addpath('apm')
y = apm_solve('model',7);

% Method #2 matrix solution for Orthogonal Collocation on Finite Elements
% Solve A x = b
% Matrix A
A = [1 -1  0  0 5     0    0     0;
    -1  1  0  0 0     0    3     0;
     0  0  1 -1 0     5    0     0;
     0  0 -1  1 0     0    0     3;
    -1  0  0  0 0.75 -0.25 0     0;
     0  0 -1  0 1     0    0     0;
     0 -1  0  0 0     0    0.75 -0.25;
     0  0  0 -1 0     0    1     0];
% Column vector b
b = [2 0 2 0 0 0 0 0]';
% Solve A x = b as x = A^-1 * b
sol = inv(A) * b;

% Method #3 with ODE15s
[t,x] = ode15s('model',[0 0.5 1], [0 0]);

disp('ODE15s solution')
disp(['x11 = ' num2str(x(2,1))])
disp(['x21 = ' num2str(x(2,2))])
disp(['x12 = ' num2str(x(3,1))])
disp(['x22 = ' num2str(x(3,2))])
disp(' ')
disp('States with Orthogonal Collocation')
disp(['x11 = ' num2str(sol(1))])
disp(['x21 = ' num2str(sol(2))])
disp(['x12 = ' num2str(sol(3)) ' (Matrix) vs ' num2str(y.x.x1(end)) ' (APM)'])
disp(['x22 = ' num2str(sol(4)) ' (Matrix) vs ' num2str(y.x.x2(end)) ' (APM)'])
disp(' ')
disp('Derivatives with Orthogonal Collocation')
disp(['d(x11)/dt = ' num2str(sol(5))])
disp(['d(x21)/dt = ' num2str(sol(6))])
disp(['d(x12)/dt = ' num2str(sol(7))])
disp(['d(x22)/dt = ' num2str(sol(8))])
