# pip install APMonitor
from APMonitor.apm import *

s = 'http://byu.apmonitor.com'
a = 'measles_sq_error'

apm(s,a,'clear all')

apm_load(s,a,'measles_biweek.apm')
csv_load(s,a,'measles_biweek.csv')

# known parameters
# number of biweeks in a year
nb = 26
apm_info(s,a,'FV','N')
apm_info(s,a,'FV','MU')

apm_info(s,a,'FV','GAMMA')
apm_option(s,a,'gamma.status',1)
apm_option(s,a,'gamma.lower',0.05)
apm_option(s,a,'gamma.upper',2)

apm_info(s,a,'FV','REP_FRAC')
# beta values (unknown parameters in the model)
for i in range(0,nb):
   apm_info(s,a,'FV','BETA['+str(i+1)+']')
   apm_option(s,a,'BETA['+str(i+1)+'].status',1)
# predicted values
apm_info(s,a,'SV','S')
apm_info(s,a,'SV','I')
# measured values
apm_info(s,a,'CV','CASES')
apm_option(s,a,'cases.wmodel',0)

# options
# imode = 5, dynamic estimation
apm_option(s,a,'nlc.imode',5)
# ev_type = 1 (L1-norm) or 2 (squared error)
apm_option(s,a,'nlc.ev_type',2)
# meas_gap = deadband that represents level of accuracy / measurement noise
apm_option(s,a,'CASES.meas_gap',100)
# ctrl_units = 5, time units are in years
apm_option(s,a,'nlc.ctrl_units',5)
# turn on feedback status for CASES
apm_option(s,a,'CASES.fstatus',1)

# solve model and print solver output
output = apm(s,a,'solve')
print (output)

# open web-interface to view results
apm_web(s,a)
