# specify server and application name
s = 'http://byu.apmonitor.com'
a = 'bryson'

from apm import *
apm(s,a,'clear all')
apm_load(s,a,'bryson.apm')
csv_load(s,a,'bryson.csv')

apm_option(s,a,'nlc.nodes',2)
apm_option(s,a,'nlc.solver',3)
apm_option(s,a,'nlc.imode',6)
apm_option(s,a,'nlc.mv_type',1)

apm_info(s,a,'MV','u')
apm_option(s,a,'u.status',1)
apm_option(s,a,'u.dcost',1e-5)

output = apm(s,a,'solve')
print (output)
y = apm_sol(s,a)

print ('Optimal Solution: ' + str(y['myobj'][-1]))

import matplotlib.pyplot as plt
plt.figure(1)

plt.subplot(2,1,1)
plt.plot(y['time'],y['x1'],'b--',linewidth=2)
plt.plot(y['time'],y['x2'],'g:',linewidth=2)
plt.plot(y['time'],y['u'],'r.-',linewidth=2)
plt.legend(['x1','x2','u'])
plt.ylabel('Variables')
plt.axis([0,1.5,-1.2,1.2])

plt.subplot(2,1,2)
plt.plot(y['time'],y['myobj'],'k-',linewidth=2)
plt.ylabel('Objective')
plt.axis([0,1.5,0,0.4])

plt.xlabel('Time')
plt.show()
