clear all; close all; clc

s = 'http://byu.apmonitor.com';
a = 'bryson';

addpath('apm')
apm(s,a,'clear all');
apm_load(s,a,'bryson.apm');
csv_load(s,a,'bryson.csv');

apm_option(s,a,'nlc.nodes',2);
apm_option(s,a,'nlc.solver',3);
apm_option(s,a,'nlc.imode',6);
apm_option(s,a,'nlc.mv_type',1);

apm_info(s,a,'MV','u');
apm_option(s,a,'u.status',1);
apm_option(s,a,'u.dcost',1e-5);

output = apm(s,a,'solve');
disp(output)
y = apm_sol(s,a);
z = y.x;

disp(['Optimal Solution: ' num2str(z.myobj(end))])

figure(1)

plot(z.time,z.x1,'b--','linewidth',2)
hold on
plot(z.time,z.x2,'g:','linewidth',2)
plot(z.time,z.u,'r.-','linewidth',2)
legend('x1','x2','u')
ylabel('Variables')
xlabel('Time')
axis([0,1.5,-1.2,1.2])
