function msg = mpc_init(s,a)

% -------------------------------------------
% Setting up APMonitor
% For any tutorials see
% http://apmonitor.com/wiki/index.php/Main/MATLAB
% -------------------------------------------

% Add path to APM libraries
coder.extrinsic('addpath');
addpath('apm');

% Clear previous application
apm(s,a,'clear all');

% load model variables and equations
apm_load(s,a,'mpc.apm');

% load data
csv_load(s,a,'mpc.csv');

%  APM Variable Classification
apm_info(s,a,'MV','P');
apm_info(s,a,'CV','L');

% Options
apm_option(s,a,'nlc.imode',6);
apm_option(s,a,'nlc.nodes',3);
apm_option(s,a,'nlc.web_plot_freq',1);
% Bounds
apm_option(s,a,'P.lower',0);
apm_option(s,a,'P.upper',1);
% Turn on parameters to control
apm_option(s,a,'P.status',1);
apm_option(s,a,'P.dmax',0.1);
apm_option(s,a,'P.fstatus',0);
apm_option(s,a,'L.status',1);
apm_option(s,a,'L.fstatus',1);
apm_option(s,a,'L.tau',105);

return