function output = mpc(inputs)

persistent s a icount

if (isempty(icount)),
    % Select server and application name
    s = 'http://byu.apmonitor.com';
    
    a = 'controller_abe';
    % Initialize MPC controller
    mpc_init(s,a)
    % Initialize counter
    icount = 0;
    % first cycle, set L = 0
    L = 0;
    P = 0;
else
    icount = icount + 1;
    % process inputs
    Lsp = inputs(1);
    L_meas = inputs(2);
    
    % Input setpoint and measurements
    apm_option(s,a,'L.sphi',Lsp+.01);
    apm_option(s,a,'L.splo',Lsp-.05);
    apm_meas(s,a,'L',L_meas);
    
    % Solve
    output = apm(s,a,'solve');
    disp(output)
    
    % Output parameters, check if good solution
    if (apm_tag(s,a,'nlc.appstatus')==1),
        P = apm_tag(s,a,'P.newval');
    else
        P = P;
    end
end

% output Tc value
if isnan(P)
    % protect outputs against bad solutions
    output = 0;
else
    output = P;
end

if (icount==5),
    % open web-viewer
    apm_web(s,a);
end

return