clear all; close all; clc

% Method #1 with APMonitor
addpath('apm')
yapm = apm_solve('model',6);

% Method #2 matrix solution for Orthogonal Collocation on Finite Elements
%
% min (x-3)^2
% s.t. 5 * dx/dt = -x + 2 * u
%
% Equations 1-2 (subject to equations at each node)
% 5 * xdot1 = -x1 + 2*u1
% 5 * xdot2 = -x2 + 2*u2
% Equations 3-4 (collocation equations)
% t2 * 0.75 * xdot1 - t2 * 0.25 * xdot2 = x1 - x0
% t2 * 1.00 * xdot1 = x2 - x0
% Equations 5-6 (derivative of objective = 0)
% 2 * (x1-3) = 0
% 2 * (x2-3) = 0
% 
% Rearrange to put all variables on left-hand side
% Equations 1-2 (subject to equations at each node)
% 5 * xdot1 + x1 - 2*u1 = 0
% 5 * xdot2 + x2 - 2*u2 = 0
% Equations 3-4 (collocation equations)
% t2 * 0.75 * xdot1 - t2 * 0.25 * xdot2 - x1 = -x0
% t2 * 1.00 * xdot1 - x2 = -x0
% Equations 5-6 (derivative of objective = 0)
% 2 * x1 = 6
% 2 * x2 = 6
%
% Set-up and solve A y = b
% y = [xdot1 xdot2 x1 x2 u1 u2]
% Matrix A
A = [5     0     1   0   -2   0;
     0     5     0   1    0  -2;
     0.75 -0.25 -1   0    0   0;
     1.00  0     0  -1    0   0;
     0     0     2   0    0   0;
     0     0     0   2    0   0];
% Column vector b
b = [0 0 0 0 6 6]';
% Solve A y = b as y = A^-1 * b
ymat = inv(A) * b;

disp('Variables with Orthogonal Collocation')
disp(['u1 = ' num2str(ymat(5))])
disp(['u2 = ' num2str(ymat(6)) ' (Matrix) vs ' num2str(yapm.x.u(end)) ' (APM)'])
disp(['x1 = ' num2str(ymat(3))])
disp(['x2 = ' num2str(ymat(4)) ' (Matrix) vs ' num2str(yapm.x.x(end)) ' (APM)'])
disp(' ')
disp('Derivatives with Orthogonal Collocation')
disp(['d(x11)/dt = ' num2str(ymat(1))])
disp(['d(x21)/dt = ' num2str(ymat(2))])
