
% Clear MATLAB
clc
clear all
close all

% load apm libraries
addpath('apm');

% model and data files
model_file = 'ethyl.apm';
data_file = 'Reduced.csv';

% assign server and application names
server = 'http://xps.apmonitor.com';

app = 'dynamic_estimate';

% clear previous application
apm(server,app,'clear all');

% load model variables and equation
apm_load(server,app,model_file);
csv_load(server,app,data_file);

% parameters to fit model
apm_info(server,app,'FV','Ea1');
apm_info(server,app,'FV','Ea2');
apm_info(server,app,'FV','A1');
apm_info(server,app,'FV','A2');
apm_info(server,app,'FV','alpha');
apm_info(server,app,'FV','beta');
apm_info(server,app,'FV','kappa');
apm_info(server,app,'FV','delta');

% State variables, not measured
apm_info(server,app,'SV','NaAc');
apm_info(server,app,'SV','EtOH');
apm_info(server,app,'SV','EtAc');

% controlled and measured variables
apm_info(server,app,'CV','OH');

% options
apm_option(server,app,'nlc.imode',5);
apm_option(server,app,'nlc.solver',1);
apm_option(server,app,'nlc.max_iter',200);
apm_option(server,app,'nlc.ev_type',1);
% adjust measurement gap to acount for noise
apm_option(server,app,'OH.meas_gap',0.001);
apm_option(server,app,'OH.wmeas',1000);

% eliminate dcost
apm_option(server,app,'A1.dcost',0.0);
apm_option(server,app,'A2.dcost',0.0);
apm_option(server,app,'Ea1.dcost',0.0);
apm_option(server,app,'Ea2.dcost',0.0);

% initialize problem
apm_option(server,app,'nlc.coldstart',1);
output = apm(server,app,'solve');
disp(output)
apm_option(server,app,'nlc.time_shift',0);

% solve for parameters
apm_option(server,app,'Ea1.status',1);
apm_option(server,app,'A1.status',1);

disp(['Ea1: ' num2str(apm_tag(server,app,'ea1.newval'))])
disp(['A1: ' num2str(apm_tag(server,app,'a1.newval'))])

%solve
apm(server,app,'solve')

apm_option(server,app,'Ea2.status',1);
apm_option(server,app,'A2.status',1);

%solve again
output = apm(server,app,'solve');
disp(output)

disp(['Ea1: ' num2str(apm_tag(server,app,'ea1.newval'))])
disp(['A1: ' num2str(apm_tag(server,app,'a1.newval'))])
disp(['Ea2: ' num2str(apm_tag(server,app,'ea2.newval'))])
disp(['A2: ' num2str(apm_tag(server,app,'a2.newval'))])

% change this to true to estimate alpha and beta
if false,
    % solve for alpha and beta
	apm_option(server,app,'alpha.status',1);
	apm_option(server,app,'beta.status',1);
	apm_option(server,app,'kappa.status',1);
	apm_option(server,app,'delta.status',1);
	apm(server,app,'solve')
end

% retrieve results
solution = apm_sol(server,app);

% extract values
z = solution.x;

% Begin Stats
best_obj = apm_tag(server,app,'nlc.objfcnval');

disp(['Best obj: ' num2str(best_obj)])

% Insert optimal solution
ea1 = z.ea1(1);
ea2 = z.ea2(1);
a1 = z.a1(1);
a2 = z.a2(1);
% display values
disp(['Ea1: ' num2str(ea1)])
disp(['Ea2: ' num2str(ea2)])
disp(['A1:  ' num2str(a1)])
disp(['A2:  ' num2str(a2)])

% insert fixed values
apm_meas(server,app,'Ea1',ea1);
apm_meas(server,app,'Ea2',ea2);
apm_meas(server,app,'A1',a1);
apm_meas(server,app,'A2',a2);

apm_option(server,app,'Ea1.upper',1e20);
apm_option(server,app,'Ea2.upper',1e20);
apm_option(server,app,'A1.upper',1e20);
apm_option(server,app,'A2.upper',1e20);

apm_option(server,app,'Ea1.lower',-1e20);
apm_option(server,app,'Ea2.lower',-1e20);
apm_option(server,app,'A1.lower',-1e20);
apm_option(server,app,'A2.lower',-1e20);

% (S(theta) - S(theta*)) / S(theta*) <= p / (n-p) * F(p,n-p,1-alpha)
p = 4; % number of parameters
n = 138; % number of data points
alpha = 0.05; % alpha, confidence interval
rhs = p / (n-p) * finv(1-alpha,p,(n-p));
ub = best_obj * rhs + best_obj;

% turn off parameters
apm_option(server,app,'A1.status',0);
apm_option(server,app,'A2.status',0);
apm_option(server,app,'Ea1.status',0);
apm_option(server,app,'Ea2.status',0);

% find confidence interval for A1
n = 12;  % number of points
A1 = linspace(0.9*a1,1.1*a1,n);
for i = 1:n;
   apm_meas(server,app,'A1',A1(i));
   apm(server,app,'solve')
   if (apm_tag(server,app,'nlc.appstatus')==1),
       obj_a1(i) = apm_tag(server,app,'nlc.objfcnval');
   else
       obj_a1(i) = NaN;
   end
end
% restore original value
apm_meas(server,app,'A1',a1);
figure(1)
plot(A1,obj_a1,'r-','LineWidth',3);
hold on
plot(A1,ub*ones(n,1),'k-','LineWidth',3);
legend('Objective','Upper Confidence Level')
title('95% Confidence Interval for A_1')
xlabel('A_1')
ylabel('SSE')

% find confidence interval for Ea1
n = 12;  % number of points
Ea1 = linspace(0.99*ea1,1.01*ea1,n);
for i = 1:n;
   apm_meas(server,app,'Ea1',Ea1(i));
   apm(server,app,'solve')
   if (apm_tag(server,app,'nlc.appstatus')==1),
       obj_ea1(i) = apm_tag(server,app,'nlc.objfcnval');
   else
       obj_ea1(i) = NaN;
   end
end
% restore original value
apm_meas(server,app,'Ea1',ea1);
figure(2)
plot(Ea1,obj_ea1,'r-','LineWidth',3);
hold on
plot(Ea1,ub*ones(n,1),'k-','LineWidth',3);
legend('Objective','Upper Confidence Level')
title('95% Confidence Interval for Ea_1')
xlabel('Ea_1')
ylabel('SSE')

% find confidence interval for A2
n = 12;  % number of points
A2 = linspace(0.9*a2,1.1*a2,n);
for i = 1:n;
   apm_meas(server,app,'A2',A2(i));
   apm(server,app,'solve')
   if (apm_tag(server,app,'nlc.appstatus')==1),
       obj_a2(i) = apm_tag(server,app,'nlc.objfcnval');
   else
       obj_a2(i) = NaN;
   end
end
% restore original value
apm_meas(server,app,'A2',a2);
figure(3)
plot(A2,obj_a1,'r-','LineWidth',3);
hold on
plot(A2,ub*ones(n,1),'k-','LineWidth',3);
legend('Objective','Upper Confidence Level')
title('95% Confidence Interval for A_2')
xlabel('A_2')
ylabel('SSE')

% find confidence interval for Ea2
n = 12;  % number of points
Ea2 = linspace(0.95*ea2,1.1*ea2,n);
for i = 1:n;
   apm_meas(server,app,'Ea2',Ea2(i));
   apm(server,app,'solve')
   if (apm_tag(server,app,'nlc.appstatus')==1),
       obj_ea2(i) = apm_tag(server,app,'nlc.objfcnval');
   else
       obj_ea2(i) = NaN;
   end
end
% restore original value
apm_meas(server,app,'Ea2',ea2);
figure(4)
plot(Ea2,obj_ea2,'r-','LineWidth',3);
hold on
plot(Ea2,ub*ones(n,1),'k-','LineWidth',3);
legend('Objective','Upper Confidence Level')
title('95% Confidence Interval for Ea_2')
xlabel('Ea_2')
ylabel('SSE')